/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.security.client;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.v2.api.MRDelegationTokenIdentifier;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;

public class ClientHSTokenSelector
implements TokenSelector<MRDelegationTokenIdentifier> {
    private static final Log LOG = LogFactory.getLog(ClientHSTokenSelector.class);

    @Override
    public Token<MRDelegationTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        LOG.debug((Object)("Looking for a token with service " + service.toString()));
        for (Token<? extends TokenIdentifier> token2 : tokens) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Token kind is " + token2.getKind().toString() + " and the token's service name is " + token2.getService()));
            }
            if (!MRDelegationTokenIdentifier.KIND_NAME.equals(token2.getKind()) || !service.equals(token2.getService())) continue;
            return token2;
        }
        return null;
    }
}

