/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.AMStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEventHandler;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

public class JobHistoryCopyService
extends CompositeService
implements HistoryEventHandler {
    private static final Log LOG = LogFactory.getLog(JobHistoryCopyService.class);
    private final ApplicationAttemptId applicationAttemptId;
    private final EventHandler handler;
    private final JobId jobId;

    public JobHistoryCopyService(ApplicationAttemptId applicationAttemptId, EventHandler handler) {
        super("JobHistoryCopyService");
        this.applicationAttemptId = applicationAttemptId;
        this.jobId = TypeConverter.toYarn(TypeConverter.fromYarn(applicationAttemptId.getApplicationId()));
        this.handler = handler;
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
    }

    @Override
    public void handleEvent(HistoryEvent event) throws IOException {
        if (!(event instanceof AMStartedEvent)) {
            this.handler.handle(new JobHistoryEvent(this.jobId, event));
        }
    }

    @Override
    protected void serviceStart() throws Exception {
        try {
            this.parse();
        }
        catch (IOException e) {
            throw new YarnRuntimeException(e);
        }
        super.serviceStart();
    }

    private void parse() throws IOException {
        FSDataInputStream in = null;
        try {
            in = JobHistoryCopyService.getPreviousJobHistoryFileStream(this.getConfig(), this.applicationAttemptId);
        }
        catch (IOException e) {
            LOG.warn((Object)"error trying to open previous history file. No history data will be copied over.", (Throwable)e);
            return;
        }
        JobHistoryParser parser = new JobHistoryParser(in);
        parser.parse(this);
        IOException parseException = parser.getParseException();
        if (parseException != null) {
            LOG.info((Object)"Got an error parsing job-history file, ignoring incomplete events.", (Throwable)parseException);
        }
    }

    public static FSDataInputStream getPreviousJobHistoryFileStream(Configuration conf, ApplicationAttemptId applicationAttemptId) throws IOException {
        FSDataInputStream in = null;
        Path historyFile = null;
        String jobId = TypeConverter.fromYarn(applicationAttemptId.getApplicationId()).toString();
        String jobhistoryDir = JobHistoryUtils.getConfiguredHistoryStagingDirPrefix(conf, jobId);
        Path histDirPath = FileContext.getFileContext(conf).makeQualified(new Path(jobhistoryDir));
        FileContext fc = FileContext.getFileContext(histDirPath.toUri(), conf);
        historyFile = fc.makeQualified(JobHistoryUtils.getStagingJobHistoryFile(histDirPath, jobId, applicationAttemptId.getAttemptId() - 1));
        LOG.info((Object)("History file is at " + historyFile));
        in = fc.open(historyFile);
        return in;
    }
}

