/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsDirectoryException;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.CommandWithDestination;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class CopyCommands {
    CopyCommands() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Merge.class, "-getmerge");
        factory.addClass(Cp.class, "-cp");
        factory.addClass(CopyFromLocal.class, "-copyFromLocal");
        factory.addClass(CopyToLocal.class, "-copyToLocal");
        factory.addClass(Get.class, "-get");
        factory.addClass(Put.class, "-put");
        factory.addClass(AppendToFile.class, "-appendToFile");
    }

    public static class AppendToFile
    extends CommandWithDestination {
        public static final String NAME = "appendToFile";
        public static final String USAGE = "<localsrc> ... <dst>";
        public static final String DESCRIPTION = "Appends the contents of all the given local files to the\ngiven dst file. The dst file will be created if it does\nnot exist. If <localSrc> is -, then the input is read\nfrom stdin.";
        private static final int DEFAULT_IO_LENGTH = 0x100000;
        boolean readStdin = false;

        @Override
        protected List<PathData> expandArgument(String arg) throws IOException {
            LinkedList<PathData> items = new LinkedList<PathData>();
            if (arg.equals("-")) {
                this.readStdin = true;
            } else {
                try {
                    items.add(new PathData(new URI(arg), this.getConf()));
                }
                catch (URISyntaxException e) {
                    if (Path.WINDOWS) {
                        items.add(new PathData(arg, this.getConf()));
                    }
                    throw new IOException("Unexpected URISyntaxException: " + e.toString());
                }
            }
            return items;
        }

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            if (args.size() < 2) {
                throw new IOException("missing destination argument");
            }
            this.getRemoteDestination(args);
            super.processOptions(args);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processArguments(LinkedList<PathData> args) throws IOException {
            if (!this.dst.exists) {
                this.dst.fs.create(this.dst.path, false).close();
            }
            FileInputStream is = null;
            FSDataOutputStream fos = this.dst.fs.append(this.dst.path);
            try {
                if (this.readStdin) {
                    if (args.size() == 0) {
                        IOUtils.copyBytes(System.in, (OutputStream)fos, 0x100000);
                    } else {
                        throw new IOException("stdin (-) must be the sole input argument when present");
                    }
                }
                for (PathData source : args) {
                    is = new FileInputStream(source.toFile());
                    IOUtils.copyBytes((InputStream)is, (OutputStream)fos, 0x100000);
                    IOUtils.closeStream(is);
                    is = null;
                }
            }
            finally {
                if (is != null) {
                    IOUtils.closeStream(is);
                }
                if (fos != null) {
                    IOUtils.closeStream(fos);
                }
            }
        }
    }

    public static class CopyToLocal
    extends Get {
        public static final String NAME = "copyToLocal";
        public static final String USAGE = "[-p] [-ignoreCrc] [-crc] <src> ... <localdst>";
        public static final String DESCRIPTION = "Identical to the -get command.";
    }

    public static class CopyFromLocal
    extends Put {
        public static final String NAME = "copyFromLocal";
        public static final String USAGE = "[-f] [-p] <localsrc> ... <dst>";
        public static final String DESCRIPTION = "Identical to the -put command.";
    }

    public static class Put
    extends CommandWithDestination {
        public static final String NAME = "put";
        public static final String USAGE = "[-f] [-p] <localsrc> ... <dst>";
        public static final String DESCRIPTION = "Copy files from the local file system\ninto fs. Copying fails if the file already\nexists, unless the -f flag is given. Passing\n-p preserves access and modification times,\nownership and the mode. Passing -f overwrites\nthe destination if it already exists.\n";

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, "f", "p");
            cf.parse(args);
            this.setOverwrite(cf.getOpt("f"));
            this.setPreserve(cf.getOpt("p"));
            this.getRemoteDestination(args);
            this.setRecursive(true);
        }

        @Override
        protected List<PathData> expandArgument(String arg) throws IOException {
            try {
                LinkedList<PathData> items = new LinkedList<PathData>();
                items.add(new PathData(new URI(arg), this.getConf()));
                return items;
            }
            catch (URISyntaxException e) {
                throw new IOException("unexpected URISyntaxException", e);
            }
        }

        @Override
        protected void processArguments(LinkedList<PathData> args) throws IOException {
            if (args.size() == 1 && args.get(0).toString().equals("-")) {
                this.copyStreamToTarget(System.in, this.getTargetPath(args.get(0)));
                return;
            }
            super.processArguments(args);
        }
    }

    public static class Get
    extends CommandWithDestination {
        public static final String NAME = "get";
        public static final String USAGE = "[-p] [-ignoreCrc] [-crc] <src> ... <localdst>";
        public static final String DESCRIPTION = "Copy files that match the file pattern <src>\nto the local name.  <src> is kept.  When copying multiple,\nfiles, the destination must be a directory. Passing\n-p preserves access and modification times,\nownership and the mode.\n";

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, "crc", "ignoreCrc", "p");
            cf.parse(args);
            this.setWriteChecksum(cf.getOpt("crc"));
            this.setVerifyChecksum(!cf.getOpt("ignoreCrc"));
            this.setPreserve(cf.getOpt("p"));
            this.setRecursive(true);
            this.getLocalDestination(args);
        }
    }

    static class Cp
    extends CommandWithDestination {
        public static final String NAME = "cp";
        public static final String USAGE = "[-f] [-p] <src> ... <dst>";
        public static final String DESCRIPTION = "Copy files that match the file pattern <src> to a\ndestination.  When copying multiple files, the destination\nmust be a directory. Passing -p preserves access and\nmodification times, ownership and the mode. Passing -f\noverwrites the destination if it already exists.\n";

        Cp() {
        }

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(2, Integer.MAX_VALUE, "f", "p");
            cf.parse(args);
            this.setOverwrite(cf.getOpt("f"));
            this.setPreserve(cf.getOpt("p"));
            this.setRecursive(true);
            this.getRemoteDestination(args);
        }
    }

    public static class Merge
    extends FsCommand {
        public static final String NAME = "getmerge";
        public static final String USAGE = "[-nl] <src> <localdst>";
        public static final String DESCRIPTION = "Get all the files in the directories that\nmatch the source file pattern and merge and sort them to only\none file on local fs. <src> is kept.\n  -nl   Add a newline character at the end of each file.";
        protected PathData dst = null;
        protected String delimiter = null;
        protected List<PathData> srcs = null;

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            try {
                CommandFormat cf = new CommandFormat(2, Integer.MAX_VALUE, "nl");
                cf.parse(args);
                this.delimiter = cf.getOpt("nl") ? "\n" : null;
                this.dst = new PathData(new URI(args.removeLast()), this.getConf());
                if (this.dst.exists && this.dst.stat.isDirectory()) {
                    throw new PathIsDirectoryException(this.dst.toString());
                }
                this.srcs = new LinkedList<PathData>();
            }
            catch (URISyntaxException e) {
                throw new IOException("unexpected URISyntaxException", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processArguments(LinkedList<PathData> items) throws IOException {
            super.processArguments(items);
            if (this.exitCode != 0) {
                return;
            }
            FSDataOutputStream out = this.dst.fs.create(this.dst.path);
            try {
                for (PathData src : this.srcs) {
                    FSDataInputStream in = src.fs.open(src.path);
                    try {
                        IOUtils.copyBytes((InputStream)in, (OutputStream)out, this.getConf(), false);
                        if (this.delimiter == null) continue;
                        out.write(this.delimiter.getBytes("UTF-8"));
                    }
                    finally {
                        in.close();
                    }
                }
            }
            finally {
                out.close();
            }
        }

        @Override
        protected void processNonexistentPath(PathData item) throws IOException {
            this.exitCode = 1;
            super.processNonexistentPath(item);
        }

        @Override
        protected void processPath(PathData src) throws IOException {
            if (src.stat.isDirectory()) {
                if (this.getDepth() == 0) {
                    this.recursePath(src);
                }
            } else {
                this.srcs.add(src);
            }
        }
    }
}

