/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class GlobExpander {
    GlobExpander() {
    }

    public static List<String> expand(String filePattern) throws IOException {
        ArrayList<String> fullyExpanded = new ArrayList<String>();
        ArrayList<StringWithOffset> toExpand = new ArrayList<StringWithOffset>();
        toExpand.add(new StringWithOffset(filePattern, 0));
        while (!toExpand.isEmpty()) {
            StringWithOffset path = (StringWithOffset)toExpand.remove(0);
            List<StringWithOffset> expanded = GlobExpander.expandLeftmost(path);
            if (expanded == null) {
                fullyExpanded.add(path.string);
                continue;
            }
            toExpand.addAll(0, expanded);
        }
        return fullyExpanded;
    }

    private static List<StringWithOffset> expandLeftmost(StringWithOffset filePatternWithOffset) throws IOException {
        String filePattern = filePatternWithOffset.string;
        int leftmost = GlobExpander.leftmostOuterCurlyContainingSlash(filePattern, filePatternWithOffset.offset);
        if (leftmost == -1) {
            return null;
        }
        int curlyOpen = 0;
        StringBuilder prefix = new StringBuilder(filePattern.substring(0, leftmost));
        StringBuilder suffix = new StringBuilder();
        ArrayList<String> alts = new ArrayList<String>();
        StringBuilder alt = new StringBuilder();
        StringBuilder cur = prefix;
        for (int i = leftmost; i < filePattern.length(); ++i) {
            char c = filePattern.charAt(i);
            if (cur == suffix) {
                cur.append(c);
                continue;
            }
            if (c == '\\') {
                if (++i >= filePattern.length()) {
                    throw new IOException("Illegal file pattern: An escaped character does not present for glob " + filePattern + " at " + i);
                }
                c = filePattern.charAt(i);
                cur.append(c);
                continue;
            }
            if (c == '{') {
                if (curlyOpen++ == 0) {
                    alt.setLength(0);
                    cur = alt;
                    continue;
                }
                cur.append(c);
                continue;
            }
            if (c == '}' && curlyOpen > 0) {
                if (--curlyOpen == 0) {
                    alts.add(alt.toString());
                    alt.setLength(0);
                    cur = suffix;
                    continue;
                }
                cur.append(c);
                continue;
            }
            if (c == ',') {
                if (curlyOpen == 1) {
                    alts.add(alt.toString());
                    alt.setLength(0);
                    continue;
                }
                cur.append(c);
                continue;
            }
            cur.append(c);
        }
        ArrayList<StringWithOffset> exp = new ArrayList<StringWithOffset>();
        for (String string2 : alts) {
            exp.add(new StringWithOffset(prefix + string2 + suffix, prefix.length()));
        }
        return exp;
    }

    private static int leftmostOuterCurlyContainingSlash(String filePattern, int offset) throws IOException {
        int curlyOpen = 0;
        int leftmost = -1;
        boolean seenSlash = false;
        for (int i = offset; i < filePattern.length(); ++i) {
            char c = filePattern.charAt(i);
            if (c == '\\') {
                if (++i < filePattern.length()) continue;
                throw new IOException("Illegal file pattern: An escaped character does not present for glob " + filePattern + " at " + i);
            }
            if (c == '{') {
                if (curlyOpen++ != 0) continue;
                leftmost = i;
                continue;
            }
            if (c == '}' && curlyOpen > 0) {
                if (--curlyOpen != 0 || leftmost == -1 || !seenSlash) continue;
                return leftmost;
            }
            if (c != '/' || curlyOpen <= 0) continue;
            seenSlash = true;
        }
        return -1;
    }

    static class StringWithOffset {
        String string;
        int offset;

        public StringWithOffset(String string2, int offset) {
            this.string = string2;
            this.offset = offset;
        }
    }
}

