/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4JNI;
import net.jpountz.util.Utils;

final class LZ4JNICompressor
extends LZ4Compressor {
    public static final LZ4Compressor INSTANCE = new LZ4JNICompressor();

    LZ4JNICompressor() {
    }

    @Override
    public int compress(byte[] src, int srcOff, int srcLen, byte[] dest, int destOff, int maxDestLen) {
        Utils.checkRange(src, srcOff, srcLen);
        Utils.checkRange(dest, destOff, maxDestLen);
        int result2 = LZ4JNI.LZ4_compress_limitedOutput(src, srcOff, srcLen, dest, destOff, maxDestLen);
        if (result2 <= 0) {
            throw new LZ4Exception("maxDestLen is too small");
        }
        return result2;
    }
}

