/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer.async;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.ProducerRequest;
import kafka.api.ProducerResponse;
import kafka.api.ProducerResponseStatus;
import kafka.api.TopicMetadata;
import kafka.common.ErrorMapping$;
import kafka.common.FailedToSendMessageException;
import kafka.common.KafkaException;
import kafka.common.LeaderNotAvailableException;
import kafka.common.NoBrokersForPartitionException;
import kafka.common.TopicAndPartition;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.NoCompressionCodec$;
import kafka.producer.BrokerPartitionInfo;
import kafka.producer.KeyedMessage;
import kafka.producer.PartitionAndLeader;
import kafka.producer.Partitioner;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerPool;
import kafka.producer.ProducerStats;
import kafka.producer.ProducerStatsRegistry$;
import kafka.producer.ProducerTopicStats;
import kafka.producer.ProducerTopicStatsRegistry$;
import kafka.producer.SyncProducer;
import kafka.producer.async.DefaultEventHandler$;
import kafka.producer.async.DefaultEventHandler$$anonfun$dispatchSerializedData$2$;
import kafka.producer.async.DefaultEventHandler$$anonfun$kafka$producer$async$DefaultEventHandler$;
import kafka.producer.async.EventHandler;
import kafka.serializer.Encoder;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.Random$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t=d\u0001B\u0001\u0003\u0001%\u00111\u0003R3gCVdG/\u0012<f]RD\u0015M\u001c3mKJT!a\u0001\u0003\u0002\u000b\u0005\u001c\u0018P\\2\u000b\u0005\u00151\u0011\u0001\u00039s_\u0012,8-\u001a:\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001!F\u0002\u000b/\u0005\u001aB\u0001A\u0006\u0012GA\u0011AbD\u0007\u0002\u001b)\ta\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0011\u001b\t1\u0011I\\=SK\u001a\u0004BAE\n\u0016A5\t!!\u0003\u0002\u0015\u0005\taQI^3oi\"\u000bg\u000e\u001a7feB\u0011ac\u0006\u0007\u0001\t\u0015A\u0002A1\u0001\u001a\u0005\u0005Y\u0015C\u0001\u000e\u001e!\ta1$\u0003\u0002\u001d\u001b\t9aj\u001c;iS:<\u0007C\u0001\u0007\u001f\u0013\tyRBA\u0002B]f\u0004\"AF\u0011\u0005\u000b\t\u0002!\u0019A\r\u0003\u0003Y\u0003\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005!*#a\u0002'pO\u001eLgn\u001a\u0005\tU\u0001\u0011\t\u0011)A\u0005W\u000511m\u001c8gS\u001e\u0004\"\u0001L\u0017\u000e\u0003\u0011I!A\f\u0003\u0003\u001dA\u0013x\u000eZ;dKJ\u001cuN\u001c4jO\"A\u0001\u0007\u0001BC\u0002\u0013%\u0011'A\u0006qCJ$\u0018\u000e^5p]\u0016\u0014X#\u0001\u001a\u0011\u00051\u001a\u0014B\u0001\u001b\u0005\u0005-\u0001\u0016M\u001d;ji&|g.\u001a:\t\u0011Y\u0002!\u0011!Q\u0001\nI\nA\u0002]1si&$\u0018n\u001c8fe\u0002B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%I!O\u0001\bK:\u001cw\u000eZ3s+\u0005Q\u0004cA\u001e?A5\tAH\u0003\u0002>\r\u0005Q1/\u001a:jC2L'0\u001a:\n\u0005}b$aB#oG>$WM\u001d\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005u\u0005AQM\\2pI\u0016\u0014\b\u0005\u0003\u0005D\u0001\t\u0015\r\u0011\"\u0003E\u0003)YW-_#oG>$WM]\u000b\u0002\u000bB\u00191HP\u000b\t\u0011\u001d\u0003!\u0011!Q\u0001\n\u0015\u000b1b[3z\u000b:\u001cw\u000eZ3sA!A\u0011\n\u0001BC\u0002\u0013%!*\u0001\u0007qe>$WoY3s!>|G.F\u0001L!\taC*\u0003\u0002N\t\ta\u0001K]8ek\u000e,'\u000fU8pY\"Aq\n\u0001B\u0001B\u0003%1*A\u0007qe>$WoY3s!>|G\u000e\t\u0005\t#\u0002\u0011)\u0019!C\u0005%\u0006\u0019Bo\u001c9jGB\u000b'\u000f^5uS>t\u0017J\u001c4pgV\t1\u000b\u0005\u0003U3n\u0013W\"A+\u000b\u0005Y;\u0016aB7vi\u0006\u0014G.\u001a\u0006\u000316\t!bY8mY\u0016\u001cG/[8o\u0013\tQVKA\u0004ICNDW*\u00199\u0011\u0005q{fB\u0001\u0007^\u0013\tqV\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003A\u0006\u0014aa\u0015;sS:<'B\u00010\u000e!\t\u0019g-D\u0001e\u0015\t)g!A\u0002ba&L!a\u001a3\u0003\u001bQ{\u0007/[2NKR\fG-\u0019;b\u0011!I\u0007A!A!\u0002\u0013\u0019\u0016\u0001\u0006;pa&\u001c\u0007+\u0019:uSRLwN\\%oM>\u001c\b\u0005C\u0003l\u0001\u0011\u0005A.\u0001\u0004=S:LGO\u0010\u000b\b[:|\u0007/\u001d:t!\u0011\u0011\u0002!\u0006\u0011\t\u000b)R\u0007\u0019A\u0016\t\u000bAR\u0007\u0019\u0001\u001a\t\u000baR\u0007\u0019\u0001\u001e\t\u000b\rS\u0007\u0019A#\t\u000b%S\u0007\u0019A&\t\u000fES\u0007\u0013!a\u0001'\"9Q\u000f\u0001b\u0001\n\u00031\u0018AB5t'ft7-F\u0001x!\ta\u00010\u0003\u0002z\u001b\t9!i\\8mK\u0006t\u0007BB>\u0001A\u0003%q/A\u0004jgNKhn\u0019\u0011\t\u000fu\u0004!\u0019!C\u0001}\u0006i1m\u001c:sK2\fG/[8o\u0013\u0012,\u0012a \t\u0005\u0003\u0003\t\u0019\"\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003\u0019\tGo\\7jG*!\u0011\u0011BA\u0006\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003\u001b\ty!\u0001\u0003vi&d'BAA\t\u0003\u0011Q\u0017M^1\n\t\u0005U\u00111\u0001\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\t\u000f\u0005e\u0001\u0001)A\u0005\u007f\u0006q1m\u001c:sK2\fG/[8o\u0013\u0012\u0004\u0003\"CA\u000f\u0001\t\u0007I\u0011AA\u0010\u0003M\u0011'o\\6feB\u000b'\u000f^5uS>t\u0017J\u001c4p+\t\t\t\u0003E\u0002-\u0003GI1!!\n\u0005\u0005M\u0011%o\\6feB\u000b'\u000f^5uS>t\u0017J\u001c4p\u0011!\tI\u0003\u0001Q\u0001\n\u0005\u0005\u0012\u0001\u00062s_.,'\u000fU1si&$\u0018n\u001c8J]\u001a|\u0007\u0005C\u0005\u0002.\u0001\u0011\r\u0011\"\u0003\u00020\u0005aBo\u001c9jG6+G/\u00193bi\u0006\u0014VM\u001a:fg\"Le\u000e^3sm\u0006dWCAA\u0019!\ra\u00111G\u0005\u0004\u0003ki!aA%oi\"A\u0011\u0011\b\u0001!\u0002\u0013\t\t$A\u000fu_BL7-T3uC\u0012\fG/\u0019*fMJ,7\u000f[%oi\u0016\u0014h/\u00197!\u0011%\ti\u0004\u0001a\u0001\n\u0013\ty$\u0001\u000fmCN$Hk\u001c9jG6+G/\u00193bi\u0006\u0014VM\u001a:fg\"$\u0016.\\3\u0016\u0005\u0005\u0005\u0003c\u0001\u0007\u0002D%\u0019\u0011QI\u0007\u0003\t1{gn\u001a\u0005\n\u0003\u0013\u0002\u0001\u0019!C\u0005\u0003\u0017\n\u0001\u0005\\1tiR{\u0007/[2NKR\fG-\u0019;b%\u00164'/Z:i)&lWm\u0018\u0013fcR!\u0011QJA*!\ra\u0011qJ\u0005\u0004\u0003#j!\u0001B+oSRD!\"!\u0016\u0002H\u0005\u0005\t\u0019AA!\u0003\rAH%\r\u0005\t\u00033\u0002\u0001\u0015)\u0003\u0002B\u0005iB.Y:u)>\u0004\u0018nY'fi\u0006$\u0017\r^1SK\u001a\u0014Xm\u001d5US6,\u0007\u0005C\u0005\u0002^\u0001\u0011\r\u0011\"\u0003\u0002`\u00051Bo\u001c9jG6+G/\u00193bi\u0006$vNU3ge\u0016\u001c\b.\u0006\u0002\u0002bA!A+a\u0019\\\u0013\r\t)'\u0016\u0002\u0004'\u0016$\b\u0002CA5\u0001\u0001\u0006I!!\u0019\u0002/Q|\u0007/[2NKR\fG-\u0019;b)>\u0014VM\u001a:fg\"\u0004\u0003\"CA7\u0001\t\u0007I\u0011BA8\u0003i\u0019XM\u001c3QCJ$\u0018\u000e^5p]B+'\u000fV8qS\u000e\u001c\u0015m\u00195f+\t\t\t\bE\u0003U3n\u000b\t\u0004\u0003\u0005\u0002v\u0001\u0001\u000b\u0011BA9\u0003m\u0019XM\u001c3QCJ$\u0018\u000e^5p]B+'\u000fV8qS\u000e\u001c\u0015m\u00195fA!I\u0011\u0011\u0010\u0001C\u0002\u0013%\u00111P\u0001\u000eaJ|G-^2feN#\u0018\r^:\u0016\u0005\u0005u\u0004c\u0001\u0017\u0002\u0000%\u0019\u0011\u0011\u0011\u0003\u0003\u001bA\u0013x\u000eZ;dKJ\u001cF/\u0019;t\u0011!\t)\t\u0001Q\u0001\n\u0005u\u0014A\u00049s_\u0012,8-\u001a:Ti\u0006$8\u000f\t\u0005\n\u0003\u0013\u0003!\u0019!C\u0005\u0003\u0017\u000b!\u0003\u001d:pIV\u001cWM\u001d+pa&\u001c7\u000b^1ugV\u0011\u0011Q\u0012\t\u0004Y\u0005=\u0015bAAI\t\t\u0011\u0002K]8ek\u000e,'\u000fV8qS\u000e\u001cF/\u0019;t\u0011!\t)\n\u0001Q\u0001\n\u00055\u0015a\u00059s_\u0012,8-\u001a:U_BL7m\u0015;biN\u0004\u0003bBAM\u0001\u0011\u0005\u00111T\u0001\u0007Q\u0006tG\r\\3\u0015\t\u00055\u0013Q\u0014\u0005\t\u0003?\u000b9\n1\u0001\u0002\"\u00061QM^3oiN\u0004b!a)\u0002&\u0006%V\"A,\n\u0007\u0005\u001dvKA\u0002TKF\u0004R\u0001LAV+\u0001J1!!,\u0005\u00051YU-_3e\u001b\u0016\u001c8/Y4f\u0011\u001d\t\t\f\u0001C\u0005\u0003g\u000ba\u0003Z5ta\u0006$8\r[*fe&\fG.\u001b>fI\u0012\u000bG/\u0019\u000b\u0005\u0003k\u000b)\r\u0005\u0004\u0002$\u0006\u0015\u0016q\u0017\t\u0007Y\u0005-V#!/\u0011\t\u0005m\u0016\u0011Y\u0007\u0003\u0003{S1!a0\u0007\u0003\u001diWm]:bO\u0016LA!a1\u0002>\n9Q*Z:tC\u001e,\u0007\u0002CAd\u0003_\u0003\r!!.\u0002\u00115,7o]1hKNDq!a3\u0001\t\u0003\ti-A\u0005tKJL\u0017\r\\5{KR!\u0011QWAh\u0011!\ty*!3A\u0002\u0005\u0005\u0006bBAj\u0001\u0011\u0005\u0011Q[\u0001\u0014a\u0006\u0014H/\u001b;j_:\fe\u000eZ\"pY2\fG/\u001a\u000b\u0005\u0003/\f\u0019\u0010E\u0003\r\u00033\fi.C\u0002\u0002\\6\u0011aa\u00149uS>t\u0007\u0003CAR\u0003?\f\t$a9\n\u0007\u0005\u0005xKA\u0002NCB\u0004r\u0001VAs\u0003O\f),C\u0002\u0002bV\u0003B!!;\u0002p6\u0011\u00111\u001e\u0006\u0004\u0003[4\u0011AB2p[6|g.\u0003\u0003\u0002r\u0006-(!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]\"A\u0011qYAi\u0001\u0004\t)\fC\u0004\u0002x\u0002!I!!?\u00021\u001d,G\u000fU1si&$\u0018n\u001c8MSN$hi\u001c:U_BL7\r\u0006\u0003\u0002|\n\r\u0001CBAR\u0003K\u000bi\u0010E\u0002-\u0003\u007fL1A!\u0001\u0005\u0005I\u0001\u0016M\u001d;ji&|g.\u00118e\u0019\u0016\fG-\u001a:\t\u0011\t\u0015\u0011Q\u001fa\u0001\u0003o\u000b\u0011!\u001c\u0005\b\u0005\u0013\u0001A\u0011\u0002B\u0006\u000319W\r\u001e)beRLG/[8o)!\t\tD!\u0004\u0003\u0012\tU\u0001b\u0002B\b\u0005\u000f\u0001\raW\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0005'\u00119\u00011\u0001\u001e\u0003\rYW-\u001f\u0005\t\u0005/\u00119\u00011\u0001\u0002|\u0006\u0011Bo\u001c9jGB\u000b'\u000f^5uS>tG*[:u\u0011\u001d\u0011Y\u0002\u0001C\u0005\u0005;\tAa]3oIR1!q\u0004B\u0011\u0005K\u0001b!a)\u0002&\u0006\u001d\b\u0002\u0003B\u0012\u00053\u0001\r!!\r\u0002\u0011\t\u0014xn[3s\u0013\u0012D\u0001Ba\n\u0003\u001a\u0001\u0007!\u0011F\u0001\u0011[\u0016\u001c8/Y4fgB+'\u000fV8qS\u000e\u0004r\u0001VAs\u0003O\u0014Y\u0003\u0005\u0003\u0002<\n5\u0012\u0002\u0002B\u0018\u0003{\u0013ACQ=uK\n+hMZ3s\u001b\u0016\u001c8/Y4f'\u0016$\bb\u0002B\u001a\u0001\u0011%!QG\u0001\u0013OJ|W\u000f]'fgN\fw-Z:U_N+G\u000f\u0006\u0003\u0003*\t]\u0002\u0002\u0003B\u001d\u0005c\u0001\r!a9\u000295,7o]1hKN\u0004VM\u001d+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]\"9!Q\b\u0001\u0005\u0002\t}\u0012!B2m_N,GCAA'\u000f%\u0011\u0019EAA\u0001\u0012\u0003\u0011)%A\nEK\u001a\fW\u000f\u001c;Fm\u0016tG\u000fS1oI2,'\u000fE\u0002\u0013\u0005\u000f2\u0001\"\u0001\u0002\u0002\u0002#\u0005!\u0011J\n\u0004\u0005\u000fZ\u0001bB6\u0003H\u0011\u0005!Q\n\u000b\u0003\u0005\u000bB!B!\u0015\u0003HE\u0005I\u0011\u0001B*\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU1!Q\u000bB6\u0005[*\"Aa\u0016+\u0007M\u0013If\u000b\u0002\u0003\\A!!Q\fB4\u001b\t\u0011yF\u0003\u0003\u0003b\t\r\u0014!C;oG\",7m[3e\u0015\r\u0011)'D\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B5\u0005?\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0019A\"q\nb\u00013\u00111!Ea\u0014C\u0002e\u0001")
public class DefaultEventHandler<K, V>
implements EventHandler<K, V>,
Logging {
    public final ProducerConfig kafka$producer$async$DefaultEventHandler$$config;
    private final Partitioner partitioner;
    private final Encoder<V> kafka$producer$async$DefaultEventHandler$$encoder;
    private final Encoder<K> kafka$producer$async$DefaultEventHandler$$keyEncoder;
    private final ProducerPool producerPool;
    private final HashMap<String, TopicMetadata> topicPartitionInfos;
    private final boolean isSync;
    private final AtomicInteger correlationId;
    private final BrokerPartitionInfo brokerPartitionInfo;
    private final int topicMetadataRefreshInterval;
    private long lastTopicMetadataRefreshTime;
    private final Set<String> kafka$producer$async$DefaultEventHandler$$topicMetadataToRefresh;
    private final HashMap<String, Object> sendPartitionPerTopicCache;
    private final ProducerStats kafka$producer$async$DefaultEventHandler$$producerStats;
    private final ProducerTopicStats kafka$producer$async$DefaultEventHandler$$producerTopicStats;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static <K, V> HashMap<String, TopicMetadata> $lessinit$greater$default$6() {
        return DefaultEventHandler$.MODULE$.$lessinit$greater$default$6();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        DefaultEventHandler defaultEventHandler = this;
        synchronized (defaultEventHandler) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private Partitioner partitioner() {
        return this.partitioner;
    }

    public Encoder<V> kafka$producer$async$DefaultEventHandler$$encoder() {
        return this.kafka$producer$async$DefaultEventHandler$$encoder;
    }

    public Encoder<K> kafka$producer$async$DefaultEventHandler$$keyEncoder() {
        return this.kafka$producer$async$DefaultEventHandler$$keyEncoder;
    }

    private ProducerPool producerPool() {
        return this.producerPool;
    }

    private HashMap<String, TopicMetadata> topicPartitionInfos() {
        return this.topicPartitionInfos;
    }

    public boolean isSync() {
        return this.isSync;
    }

    public AtomicInteger correlationId() {
        return this.correlationId;
    }

    public BrokerPartitionInfo brokerPartitionInfo() {
        return this.brokerPartitionInfo;
    }

    private int topicMetadataRefreshInterval() {
        return this.topicMetadataRefreshInterval;
    }

    private long lastTopicMetadataRefreshTime() {
        return this.lastTopicMetadataRefreshTime;
    }

    private void lastTopicMetadataRefreshTime_$eq(long x$1) {
        this.lastTopicMetadataRefreshTime = x$1;
    }

    public Set<String> kafka$producer$async$DefaultEventHandler$$topicMetadataToRefresh() {
        return this.kafka$producer$async$DefaultEventHandler$$topicMetadataToRefresh;
    }

    private HashMap<String, Object> sendPartitionPerTopicCache() {
        return this.sendPartitionPerTopicCache;
    }

    public ProducerStats kafka$producer$async$DefaultEventHandler$$producerStats() {
        return this.kafka$producer$async$DefaultEventHandler$$producerStats;
    }

    public ProducerTopicStats kafka$producer$async$DefaultEventHandler$$producerTopicStats() {
        return this.kafka$producer$async$DefaultEventHandler$$producerTopicStats;
    }

    @Override
    public void handle(Seq<KeyedMessage<K, V>> events2) {
        Seq<KeyedMessage<K, Message>> serializedData = this.serialize(events2);
        serializedData.foreach(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultEventHandler $outer;

            public final void apply(KeyedMessage<K, Message> keyed) {
                int dataSize = keyed.message().payloadSize();
                this.$outer.kafka$producer$async$DefaultEventHandler$$producerTopicStats().getProducerTopicStats(keyed.topic()).byteRate().mark(dataSize);
                this.$outer.kafka$producer$async$DefaultEventHandler$$producerTopicStats().getProducerAllTopicsStats().byteRate().mark(dataSize);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        ObjectRef<Seq<KeyedMessage<K, Message>>> outstandingProduceRequests = new ObjectRef<Seq<KeyedMessage<K, Message>>>(serializedData);
        IntRef remainingRetries = new IntRef(this.kafka$producer$async$DefaultEventHandler$$config.messageSendMaxRetries() + 1);
        int correlationIdStart = this.correlationId().get();
        this.debug((Function0<String>)((Object)new scala.Serializable(this, events2){
            public static final long serialVersionUID = 0L;
            private final Seq events$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Handling %d events")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.events$1.size())}));
            }
            {
                this.events$1 = events$1;
            }
        }));
        while (remainingRetries.elem > 0 && ((Seq)outstandingProduceRequests.elem).size() > 0) {
            this.kafka$producer$async$DefaultEventHandler$$topicMetadataToRefresh().$plus$plus$eq(((Seq)outstandingProduceRequests.elem).map(new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(KeyedMessage<K, Message> x$1) {
                    return x$1.topic();
                }
            }, Seq$.MODULE$.canBuildFrom()));
            if (this.topicMetadataRefreshInterval() >= 0 && SystemTime$.MODULE$.milliseconds() - this.lastTopicMetadataRefreshTime() > (long)this.topicMetadataRefreshInterval()) {
                Utils$.MODULE$.swallowError((Function0<BoxedUnit>)((Object)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DefaultEventHandler $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.brokerPartitionInfo().updateInfo(this.$outer.kafka$producer$async$DefaultEventHandler$$topicMetadataToRefresh().toSet(), this.$outer.correlationId().getAndIncrement());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
                this.sendPartitionPerTopicCache().clear();
                this.kafka$producer$async$DefaultEventHandler$$topicMetadataToRefresh().clear();
                this.lastTopicMetadataRefreshTime_$eq(SystemTime$.MODULE$.milliseconds());
            }
            outstandingProduceRequests.elem = this.dispatchSerializedData((Seq)outstandingProduceRequests.elem);
            if (((Seq)outstandingProduceRequests.elem).size() <= 0) continue;
            this.info((Function0<String>)((Object)new scala.Serializable(this, remainingRetries){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DefaultEventHandler $outer;
                private final IntRef remainingRetries$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Back off for %d ms before retrying send. Remaining retries = %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$producer$async$DefaultEventHandler$$config.retryBackoffMs()), BoxesRunTime.boxToInteger(this.remainingRetries$1.elem - 1)}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.remainingRetries$1 = remainingRetries$1;
                }
            }));
            Thread.sleep(this.kafka$producer$async$DefaultEventHandler$$config.retryBackoffMs());
            Utils$.MODULE$.swallowError((Function0<BoxedUnit>)((Object)new scala.Serializable(this, outstandingProduceRequests){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DefaultEventHandler $outer;
                private final ObjectRef outstandingProduceRequests$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.brokerPartitionInfo().updateInfo(((TraversableOnce)((Seq)this.outstandingProduceRequests$1.elem).map(new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(KeyedMessage<K, Message> x$2) {
                            return x$2.topic();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toSet(), this.$outer.correlationId().getAndIncrement());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.outstandingProduceRequests$1 = outstandingProduceRequests$1;
                }
            }));
            this.sendPartitionPerTopicCache().clear();
            --remainingRetries.elem;
            this.kafka$producer$async$DefaultEventHandler$$producerStats().resendRate().mark();
        }
        if (((Seq)outstandingProduceRequests.elem).size() > 0) {
            this.kafka$producer$async$DefaultEventHandler$$producerStats().failedSendRate().mark();
            int correlationIdEnd = this.correlationId().get();
            this.error((Function0<String>)((Object)new scala.Serializable(this, outstandingProduceRequests, correlationIdStart, correlationIdEnd){
                public static final long serialVersionUID = 0L;
                private final ObjectRef outstandingProduceRequests$1;
                private final int correlationIdStart$1;
                private final int correlationIdEnd$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Failed to send requests for topics %s with correlation ids in [%d,%d]")).format(Predef$.MODULE$.genericWrapArray(new Object[]{((TraversableOnce)((Seq)this.outstandingProduceRequests$1.elem).map(new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(KeyedMessage<K, Message> x$3) {
                            return x$3.topic();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toSet().mkString(","), BoxesRunTime.boxToInteger(this.correlationIdStart$1), BoxesRunTime.boxToInteger(this.correlationIdEnd$1 - 1)}));
                }
                {
                    this.outstandingProduceRequests$1 = outstandingProduceRequests$1;
                    this.correlationIdStart$1 = correlationIdStart$1;
                    this.correlationIdEnd$1 = correlationIdEnd$1;
                }
            }));
            throw new FailedToSendMessageException(new StringBuilder().append((Object)"Failed to send messages after ").append(BoxesRunTime.boxToInteger(this.kafka$producer$async$DefaultEventHandler$$config.messageSendMaxRetries())).append((Object)" tries.").toString(), null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Seq<KeyedMessage<K, Message>> dispatchSerializedData(Seq<KeyedMessage<K, Message>> messages) {
        Option<Map<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>>> partitionedDataOpt = this.partitionAndCollate(messages);
        Option<Map<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>>> option = partitionedDataOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            Map partitionedData = (Map)some.x();
            ArrayBuffer<KeyedMessage<K, Message>> failedProduceRequests = new ArrayBuffer<KeyedMessage<K, Message>>();
            try {
                partitionedData.withFilter(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>> check$ifrefutable$1) {
                        Tuple2<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach(new scala.Serializable(this, failedProduceRequests){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DefaultEventHandler $outer;
                    public final ArrayBuffer failedProduceRequests$1;

                    public final void apply(Tuple2<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>> x$4) {
                        Tuple2<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>> tuple2 = x$4;
                        if (tuple2 != null) {
                            int brokerid = tuple2._1$mcI$sp();
                            scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>> messagesPerBrokerMap = tuple2._2();
                            if (this.$outer.logger().isTraceEnabled()) {
                                messagesPerBrokerMap.foreach(new scala.Serializable(this, brokerid){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$dispatchSerializedData$2 $outer;
                                    public final int brokerid$1;

                                    public final void apply(Tuple2<TopicAndPartition, Seq<KeyedMessage<K, Message>>> partitionAndEvent) {
                                        this.$outer.kafka$producer$async$DefaultEventHandler$$anonfun$$$outer().trace((Function0<String>)((Object)new scala.Serializable(this, partitionAndEvent){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$dispatchSerializedData$2$$anonfun$apply$2 $outer;
                                            private final Tuple2 partitionAndEvent$1;

                                            public final String apply() {
                                                return new StringOps(Predef$.MODULE$.augmentString("Handling event for Topic: %s, Broker: %d, Partitions: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.partitionAndEvent$1._1(), BoxesRunTime.boxToInteger(this.$outer.brokerid$1), this.partitionAndEvent$1._2()}));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                                this.partitionAndEvent$1 = partitionAndEvent$1;
                                            }
                                        }));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.brokerid$1 = brokerid$1;
                                    }
                                });
                            }
                            scala.collection.mutable.Map<TopicAndPartition, ByteBufferMessageSet> messageSetPerBroker = this.$outer.kafka$producer$async$DefaultEventHandler$$groupMessagesToSet(messagesPerBrokerMap);
                            Seq<TopicAndPartition> failedTopicPartitions = this.$outer.kafka$producer$async$DefaultEventHandler$$send(brokerid, messageSetPerBroker);
                            failedTopicPartitions.foreach(new scala.Serializable(this, messagesPerBrokerMap){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$dispatchSerializedData$2 $outer;
                                private final scala.collection.mutable.Map messagesPerBrokerMap$1;

                                public final void apply(TopicAndPartition topicPartition) {
                                    Option<B> option;
                                    block4: {
                                        block3: {
                                            block2: {
                                                option = this.messagesPerBrokerMap$1.get(topicPartition);
                                                if (!(option instanceof Some)) break block2;
                                                Some some = (Some)option;
                                                Seq data2 = (Seq)some.x();
                                                this.$outer.failedProduceRequests$1.appendAll(data2);
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block3;
                                            }
                                            None$ none$ = None$.MODULE$;
                                            Option<B> option2 = option;
                                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        }
                                        return;
                                    }
                                    throw new MatchError(option);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.messagesPerBrokerMap$1 = messagesPerBrokerMap$1;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }

                    public /* synthetic */ DefaultEventHandler kafka$producer$async$DefaultEventHandler$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.failedProduceRequests$1 = failedProduceRequests$1;
                    }
                });
                return failedProduceRequests;
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)((Object)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Failed to send messages";
                    }
                }), (Function0<Throwable>)((Object)new scala.Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable t$2;

                    public final Throwable apply() {
                        return this.t$2;
                    }
                    {
                        this.t$2 = t$2;
                    }
                }));
            }
            return failedProduceRequests;
        } else {
            None$ none$ = None$.MODULE$;
            Option<Map<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>>> option2 = option;
            if (none$ == null) {
                if (option2 == null) return messages;
                throw new MatchError(option);
            }
            if (!none$.equals(option2)) throw new MatchError(option);
            return messages;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Seq<KeyedMessage<K, Message>> serialize(Seq<KeyedMessage<K, V>> events2) {
        void var2_2;
        ArrayBuffer serializedMessages = new ArrayBuffer(events2.size());
        events2.foreach(new scala.Serializable(this, serializedMessages){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultEventHandler $outer;
            private final ArrayBuffer serializedMessages$1;

            public final Object apply(KeyedMessage<K, V> e) {
                Object object;
                try {
                    if (e.hasKey()) {
                        byte[] x$11 = this.$outer.kafka$producer$async$DefaultEventHandler$$keyEncoder().toBytes(e.key());
                        byte[] x$12 = this.$outer.kafka$producer$async$DefaultEventHandler$$encoder().toBytes(e.message());
                        object = this.serializedMessages$1.$plus$eq(new KeyedMessage<K, Message>(e.topic(), e.key(), e.partKey(), new Message(x$12, x$11)));
                    } else {
                        object = this.serializedMessages$1.$plus$eq(new KeyedMessage<K, Message>(e.topic(), e.key(), e.partKey(), new Message(this.$outer.kafka$producer$async$DefaultEventHandler$$encoder().toBytes(e.message()))));
                    }
                }
                catch (Throwable throwable) {
                    this.$outer.kafka$producer$async$DefaultEventHandler$$producerStats().serializationErrorRate().mark();
                    if (this.$outer.isSync()) {
                        throw throwable;
                    }
                    this.$outer.error((Function0<String>)((Object)new scala.Serializable(this, e){
                        public static final long serialVersionUID = 0L;
                        private final KeyedMessage e$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Error serializing message for topic %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.e$1.topic()}));
                        }
                        {
                            this.e$1 = e$1;
                        }
                    }), (Function0<Throwable>)((Object)new scala.Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable t$3;

                        public final Throwable apply() {
                            return this.t$3;
                        }
                        {
                            this.t$3 = t$3;
                        }
                    }));
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.serializedMessages$1 = serializedMessages$1;
            }
        });
        return var2_2;
    }

    public Option<Map<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>>> partitionAndCollate(Seq<KeyedMessage<K, Message>> messages) {
        Some<Map<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>>> some;
        HashMap ret = new HashMap();
        try {
            messages.foreach(new scala.Serializable(this, ret){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DefaultEventHandler $outer;
                private final HashMap ret$1;

                public final void apply(KeyedMessage<K, Message> message) {
                    Option<B> option;
                    block4: {
                        Option<B> option2;
                        block7: {
                            ArrayBuffer<Object> dataPerTopicPartition;
                            block6: {
                                Serializable serializable2;
                                TopicAndPartition topicAndPartition;
                                HashMap<TopicAndPartition, ArrayBuffer<A>> dataPerBroker;
                                block5: {
                                    PartitionAndLeader brokerPartition;
                                    block3: {
                                        Serializable serializable3;
                                        int leaderBrokerId;
                                        block2: {
                                            Seq<PartitionAndLeader> topicPartitionsList = this.$outer.kafka$producer$async$DefaultEventHandler$$getPartitionListForTopic(message);
                                            int partitionIndex = this.$outer.kafka$producer$async$DefaultEventHandler$$getPartition(message.topic(), message.partitionKey(), topicPartitionsList);
                                            brokerPartition = (PartitionAndLeader)topicPartitionsList.apply(partitionIndex);
                                            leaderBrokerId = BoxesRunTime.unboxToInt(brokerPartition.leaderBrokerIdOpt().getOrElse(new scala.Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final int apply() {
                                                    return this.apply$mcI$sp();
                                                }

                                                public int apply$mcI$sp() {
                                                    return -1;
                                                }
                                            }));
                                            dataPerBroker = null;
                                            option = this.ret$1.get(BoxesRunTime.boxToInteger(leaderBrokerId));
                                            if (!(option instanceof Some)) break block2;
                                            Some some = (Some)option;
                                            scala.collection.mutable.Map element = (scala.collection.mutable.Map)some.x();
                                            dataPerBroker = (HashMap<TopicAndPartition, ArrayBuffer<A>>)element;
                                            serializable3 = BoxedUnit.UNIT;
                                            break block3;
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option<B> option3 = option;
                                        if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                                        dataPerBroker = new HashMap<TopicAndPartition, ArrayBuffer<A>>();
                                        serializable3 = this.ret$1.put(BoxesRunTime.boxToInteger(leaderBrokerId), dataPerBroker);
                                    }
                                    topicAndPartition = new TopicAndPartition(message.topic(), brokerPartition.partitionId());
                                    dataPerTopicPartition = null;
                                    option2 = dataPerBroker.get(topicAndPartition);
                                    if (!(option2 instanceof Some)) break block5;
                                    Some some = (Some)option2;
                                    Seq element = (Seq)some.x();
                                    dataPerTopicPartition = (ArrayBuffer<Object>)element;
                                    serializable2 = BoxedUnit.UNIT;
                                    break block6;
                                }
                                None$ none$ = None$.MODULE$;
                                Option<B> option4 = option2;
                                if (none$ != null ? !none$.equals(option4) : option4 != null) break block7;
                                dataPerTopicPartition = new ArrayBuffer<Object>();
                                serializable2 = dataPerBroker.put(topicAndPartition, dataPerTopicPartition);
                            }
                            dataPerTopicPartition.append(Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{message}));
                            return;
                        }
                        throw new MatchError(option2);
                    }
                    throw new MatchError(option);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.ret$1 = ret$1;
                }
            });
            some = new Some(ret);
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)((Object)new scala.Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable oe$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to collate messages by topic, partition due to: ").append((Object)this.oe$1.getMessage()).toString();
                }
                {
                    this.oe$1 = oe$1;
                }
            }));
            some = None$.MODULE$;
        }
        catch (LeaderNotAvailableException leaderNotAvailableException) {
            this.warn((Function0<String>)((Object)new scala.Serializable(this, leaderNotAvailableException){
                public static final long serialVersionUID = 0L;
                private final LeaderNotAvailableException lnae$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to collate messages by topic,partition due to: ").append((Object)this.lnae$1.getMessage()).toString();
                }
                {
                    this.lnae$1 = lnae$1;
                }
            }));
            some = None$.MODULE$;
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
            this.warn((Function0<String>)((Object)new scala.Serializable(this, unknownTopicOrPartitionException){
                public static final long serialVersionUID = 0L;
                private final UnknownTopicOrPartitionException ute$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to collate messages by topic,partition due to: ").append((Object)this.ute$1.getMessage()).toString();
                }
                {
                    this.ute$1 = ute$1;
                }
            }));
            some = None$.MODULE$;
        }
        return some;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<PartitionAndLeader> kafka$producer$async$DefaultEventHandler$$getPartitionListForTopic(KeyedMessage<K, Message> m) {
        void var2_2;
        Seq<PartitionAndLeader> topicPartitionsList = this.brokerPartitionInfo().getBrokerPartitionInfo(m.topic(), this.correlationId().getAndIncrement());
        this.debug((Function0<String>)((Object)new scala.Serializable(this, m, topicPartitionsList){
            public static final long serialVersionUID = 0L;
            private final KeyedMessage m$1;
            private final Seq topicPartitionsList$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Broker partitions registered for topic: %s are %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.m$1.topic(), ((TraversableOnce)this.topicPartitionsList$1.map(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(PartitionAndLeader p) {
                        return p.partitionId();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(",")}));
            }
            {
                void var3_3;
                this.m$1 = m$1;
                this.topicPartitionsList$1 = var3_3;
            }
        }));
        int totalNumPartitions = topicPartitionsList.length();
        if (totalNumPartitions == 0) {
            throw new NoBrokersForPartitionException(new StringBuilder().append((Object)"Partition key = ").append(m.key()).toString());
        }
        return var2_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int kafka$producer$async$DefaultEventHandler$$getPartition(String topic, Object key, Seq<PartitionAndLeader> topicPartitionList) {
        int partition2;
        int n;
        int numPartitions = topicPartitionList.size();
        if (numPartitions <= 0) {
            throw new UnknownTopicOrPartitionException(new StringBuilder().append((Object)"Topic ").append((Object)topic).append((Object)" doesn't exist").toString());
        }
        if (key == null) {
            int n2;
            Option<Object> id = this.sendPartitionPerTopicCache().get(topic);
            Option<Object> option = id;
            if (option instanceof Some) {
                int partitionId;
                Some some = (Some)option;
                n2 = partitionId = BoxesRunTime.unboxToInt(some.x());
            } else {
                None$ none$ = None$.MODULE$;
                Option<Object> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) throw new MatchError(option);
                Seq availablePartitions = (Seq)topicPartitionList.filter((Function1<PartitionAndLeader, Object>)((Object)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(PartitionAndLeader x$5) {
                        return x$5.leaderBrokerIdOpt().isDefined();
                    }
                }));
                if (availablePartitions.isEmpty()) {
                    throw new LeaderNotAvailableException(new StringBuilder().append((Object)"No leader for any partition in topic ").append((Object)topic).toString());
                }
                int index2 = Utils$.MODULE$.abs(Random$.MODULE$.nextInt()) % availablePartitions.size();
                int partitionId = ((PartitionAndLeader)availablePartitions.apply(index2)).partitionId();
                this.sendPartitionPerTopicCache().put(topic, BoxesRunTime.boxToInteger(partitionId));
                n2 = partitionId;
            }
            n = n2;
        } else {
            n = partition2 = this.partitioner().partition(key, numPartitions);
        }
        if (partition2 < 0 || partition2 >= numPartitions) {
            throw new UnknownTopicOrPartitionException(new StringBuilder().append((Object)"Invalid partition id: ").append(BoxesRunTime.boxToInteger(partition2)).append((Object)" for topic ").append((Object)topic).append((Object)"; Valid values are in the inclusive range of [0, ").append(BoxesRunTime.boxToInteger(numPartitions - 1)).append((Object)"]").toString());
        }
        this.trace((Function0<String>)((Object)new scala.Serializable(this, topic, key, partition2){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final Object key$1;
            private final int partition$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Assigning message of topic %s and key %s to a selected partition %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$1, this.key$1 == null ? "[none]" : this.key$1.toString(), BoxesRunTime.boxToInteger(this.partition$1)}));
            }
            {
                void var3_3;
                this.topic$1 = topic$1;
                this.key$1 = var3_3;
                this.partition$1 = partition$1;
            }
        }));
        return partition2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Seq<TopicAndPartition> kafka$producer$async$DefaultEventHandler$$send(int brokerId, scala.collection.mutable.Map<TopicAndPartition, ByteBufferMessageSet> messagesPerTopic) {
        Seq seq;
        if (brokerId < 0) {
            this.warn((Function0<String>)((Object)new scala.Serializable(this, messagesPerTopic){
                public static final long serialVersionUID = 0L;
                private final scala.collection.mutable.Map messagesPerTopic$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Failed to send data since partitions %s don't have a leader")).format(Predef$.MODULE$.genericWrapArray(new Object[]{((TraversableOnce)this.messagesPerTopic$1.map(new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final TopicAndPartition apply(Tuple2<TopicAndPartition, ByteBufferMessageSet> x$6) {
                            return x$6._1();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).mkString(",")}));
                }
                {
                    this.messagesPerTopic$1 = messagesPerTopic$1;
                }
            }));
            seq = messagesPerTopic.keys().toSeq();
            return seq;
        }
        if (messagesPerTopic.size() <= 0) {
            seq = List$.MODULE$.empty();
            return seq;
        }
        int currentCorrelationId = this.correlationId().getAndIncrement();
        ProducerRequest producerRequest = new ProducerRequest(currentCorrelationId, this.kafka$producer$async$DefaultEventHandler$$config.clientId(), this.kafka$producer$async$DefaultEventHandler$$config.requestRequiredAcks(), this.kafka$producer$async$DefaultEventHandler$$config.requestTimeoutMs(), messagesPerTopic);
        Seq failedTopicPartitions = (Seq)Seq$.MODULE$.empty();
        try {
            Seq<Tuple2<Tuple2<TopicAndPartition, ProducerResponseStatus>, TopicAndPartition>> failedPartitionsAndStatus;
            SyncProducer syncProducer = this.producerPool().getProducer(brokerId);
            this.debug((Function0<String>)((Object)new scala.Serializable(this, brokerId, messagesPerTopic, currentCorrelationId, syncProducer){
                public static final long serialVersionUID = 0L;
                private final int brokerId$1;
                private final scala.collection.mutable.Map messagesPerTopic$1;
                private final int currentCorrelationId$1;
                private final SyncProducer syncProducer$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Producer sending messages with correlation id %d for topics %s to broker %d on %s:%d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.currentCorrelationId$1), this.messagesPerTopic$1.keySet().mkString(","), BoxesRunTime.boxToInteger(this.brokerId$1), this.syncProducer$1.config().host(), BoxesRunTime.boxToInteger(this.syncProducer$1.config().port())}));
                }
                {
                    void var5_5;
                    void var3_3;
                    this.brokerId$1 = brokerId$1;
                    this.messagesPerTopic$1 = var3_3;
                    this.currentCorrelationId$1 = currentCorrelationId$1;
                    this.syncProducer$1 = var5_5;
                }
            }));
            ProducerResponse response = syncProducer.send(producerRequest);
            this.debug((Function0<String>)((Object)new scala.Serializable(this, brokerId, messagesPerTopic, currentCorrelationId, syncProducer){
                public static final long serialVersionUID = 0L;
                private final int brokerId$1;
                private final scala.collection.mutable.Map messagesPerTopic$1;
                private final int currentCorrelationId$1;
                private final SyncProducer syncProducer$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Producer sent messages with correlation id %d for topics %s to broker %d on %s:%d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.currentCorrelationId$1), this.messagesPerTopic$1.keySet().mkString(","), BoxesRunTime.boxToInteger(this.brokerId$1), this.syncProducer$1.config().host(), BoxesRunTime.boxToInteger(this.syncProducer$1.config().port())}));
                }
                {
                    void var5_5;
                    void var3_3;
                    this.brokerId$1 = brokerId$1;
                    this.messagesPerTopic$1 = var3_3;
                    this.currentCorrelationId$1 = currentCorrelationId$1;
                    this.syncProducer$1 = var5_5;
                }
            }));
            if (response == null) {
                seq = (Seq)Seq$.MODULE$.empty();
                return seq;
            }
            if (response.status().size() != producerRequest.data().size()) {
                throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Incomplete response (%s) for producer request (%s)")).format(Predef$.MODULE$.genericWrapArray(new Object[]{response, producerRequest})));
            }
            if (this.logger().isTraceEnabled()) {
                Map successfullySentData = (Map)response.status().filter((Function1<TopicAndPartition, Object>)((Object)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<TopicAndPartition, ProducerResponseStatus> x$7) {
                        return x$7._2().error() == ErrorMapping$.MODULE$.NoError();
                    }
                }));
                successfullySentData.foreach(new scala.Serializable(this, messagesPerTopic){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DefaultEventHandler $outer;
                    private final scala.collection.mutable.Map messagesPerTopic$1;

                    public final void apply(Tuple2<TopicAndPartition, ProducerResponseStatus> m) {
                        ((IterableLike)this.messagesPerTopic$1.apply(m._1())).foreach(new scala.Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$kafka$producer$async$DefaultEventHandler$$send$4 $outer;

                            public final void apply(MessageAndOffset message) {
                                this.$outer.kafka$producer$async$DefaultEventHandler$$anonfun$$$outer().trace((Function0<String>)((Object)new scala.Serializable(this, message){
                                    public static final long serialVersionUID = 0L;
                                    private final MessageAndOffset message$1;

                                    public final String apply() {
                                        Object[] objectArray = new Object[1];
                                        objectArray[0] = this.message$1.message().isNull() ? null : Utils$.MODULE$.readString(this.message$1.message().payload(), Utils$.MODULE$.readString$default$2());
                                        return new StringOps(Predef$.MODULE$.augmentString("Successfully sent message: %s")).format(Predef$.MODULE$.genericWrapArray(objectArray));
                                    }
                                    {
                                        this.message$1 = message$1;
                                    }
                                }));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ DefaultEventHandler kafka$producer$async$DefaultEventHandler$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.messagesPerTopic$1 = messagesPerTopic$1;
                    }
                });
            }
            if ((failedTopicPartitions = (failedPartitionsAndStatus = ((MapLike)response.status().filter((Function1<TopicAndPartition, Object>)((Object)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<TopicAndPartition, ProducerResponseStatus> x$8) {
                    return x$8._2().error() != ErrorMapping$.MODULE$.NoError();
                }
            }))).toSeq()).map(new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TopicAndPartition apply(Tuple2<TopicAndPartition, ProducerResponseStatus> partitionStatus) {
                    return partitionStatus._1();
                }
            }, Seq$.MODULE$.canBuildFrom())).size() > 0) {
                String errorString = ((TraversableOnce)((TraversableLike)failedPartitionsAndStatus.sortWith((Function2<Tuple2<Tuple2<TopicAndPartition, ProducerResponseStatus>, TopicAndPartition>, Tuple2<Tuple2<TopicAndPartition, ProducerResponseStatus>, TopicAndPartition>, Object>)((Object)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<TopicAndPartition, ProducerResponseStatus> p1, Tuple2<TopicAndPartition, ProducerResponseStatus> p2) {
                        return p1._1().topic().compareTo(p2._1().topic()) < 0 || p1._1().topic().compareTo(p2._1().topic()) == 0 && p1._1().partition() < p2._1().partition();
                    }
                }))).map(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<TopicAndPartition, ProducerResponseStatus> x0$2) {
                        Tuple2<TopicAndPartition, ProducerResponseStatus> tuple2 = x0$2;
                        if (tuple2 != null) {
                            TopicAndPartition topicAndPartition = tuple2._1();
                            ProducerResponseStatus status = tuple2._2();
                            String string2 = new StringBuilder().append((Object)topicAndPartition.toString()).append((Object)": ").append((Object)ErrorMapping$.MODULE$.exceptionFor(status.error()).getClass().getName()).toString();
                            return string2;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(",");
                this.warn((Function0<String>)((Object)new scala.Serializable(this, currentCorrelationId, errorString){
                    public static final long serialVersionUID = 0L;
                    private final int currentCorrelationId$1;
                    private final String errorString$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Produce request with correlation id %d failed due to %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.currentCorrelationId$1), this.errorString$1}));
                    }
                    {
                        void var3_3;
                        this.currentCorrelationId$1 = currentCorrelationId$1;
                        this.errorString$1 = var3_3;
                    }
                }));
            }
            seq = failedTopicPartitions;
            return seq;
        }
        catch (Throwable throwable) {
            this.warn((Function0<String>)((Object)new scala.Serializable(this, brokerId, messagesPerTopic, currentCorrelationId){
                public static final long serialVersionUID = 0L;
                private final int brokerId$1;
                private final scala.collection.mutable.Map messagesPerTopic$1;
                private final int currentCorrelationId$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Failed to send producer request with correlation id %d to broker %d with data for partitions %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.currentCorrelationId$1), BoxesRunTime.boxToInteger(this.brokerId$1), ((TraversableOnce)this.messagesPerTopic$1.map(new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final TopicAndPartition apply(Tuple2<TopicAndPartition, ByteBufferMessageSet> x$9) {
                            return x$9._1();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).mkString(",")}));
                }
                {
                    void var3_3;
                    this.brokerId$1 = brokerId$1;
                    this.messagesPerTopic$1 = var3_3;
                    this.currentCorrelationId$1 = currentCorrelationId$1;
                }
            }), (Function0<Throwable>)((Object)new scala.Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$1;

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = t$1;
                }
            }));
            seq = messagesPerTopic.keys().toSeq();
        }
        return seq;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.mutable.Map<TopicAndPartition, ByteBufferMessageSet> kafka$producer$async$DefaultEventHandler$$groupMessagesToSet(scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>> messagesPerTopicAndPartition) {
        void var2_2;
        scala.collection.mutable.Map messagesPerTopicPartition = messagesPerTopicAndPartition.map((Function1<TopicAndPartition, Seq<KeyedMessage<K, Message>>>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultEventHandler $outer;

            public final Tuple2<TopicAndPartition, ByteBufferMessageSet> apply(Tuple2<TopicAndPartition, Seq<KeyedMessage<K, Message>>> x0$1) {
                Tuple2<TopicAndPartition, Seq<KeyedMessage<K, Message>>> tuple2 = x0$1;
                if (tuple2 != null) {
                    ByteBufferMessageSet byteBufferMessageSet;
                    TopicAndPartition topicAndPartition = tuple2._1();
                    Seq<KeyedMessage<K, Message>> messages = tuple2._2();
                    Seq<Message> rawMessages = messages.map(new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Message apply(KeyedMessage<K, Message> x$10) {
                            return x$10.message();
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    CompressionCodec compressionCodec = this.$outer.kafka$producer$async$DefaultEventHandler$$config.compressionCodec();
                    NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                    CompressionCodec compressionCodec2 = compressionCodec;
                    if (!(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null)) {
                        this.$outer.debug((Function0<String>)((Object)new scala.Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final TopicAndPartition topicAndPartition$1;
                            private final Seq messages$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Sending %d messages with no compression to %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.messages$1.size()), this.topicAndPartition$1}));
                            }
                            {
                                this.topicAndPartition$1 = topicAndPartition$1;
                                this.messages$1 = messages$1;
                            }
                        }));
                        byteBufferMessageSet = new ByteBufferMessageSet(NoCompressionCodec$.MODULE$, rawMessages);
                    } else {
                        ByteBufferMessageSet byteBufferMessageSet2;
                        int n = this.$outer.kafka$producer$async$DefaultEventHandler$$config.compressedTopics().size();
                        switch (n) {
                            default: {
                                if (this.$outer.kafka$producer$async$DefaultEventHandler$$config.compressedTopics().contains(topicAndPartition.topic())) {
                                    this.$outer.debug((Function0<String>)((Object)new scala.Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$7 $outer;
                                        private final TopicAndPartition topicAndPartition$1;
                                        private final Seq messages$1;

                                        public final String apply() {
                                            return new StringOps(Predef$.MODULE$.augmentString("Sending %d messages with compression codec %d to %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.messages$1.size()), BoxesRunTime.boxToInteger(this.$outer.kafka$producer$async$DefaultEventHandler$$anonfun$$$outer().kafka$producer$async$DefaultEventHandler$$config.compressionCodec().codec()), this.topicAndPartition$1}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                            this.topicAndPartition$1 = topicAndPartition$1;
                                            this.messages$1 = messages$1;
                                        }
                                    }));
                                    byteBufferMessageSet2 = new ByteBufferMessageSet(this.$outer.kafka$producer$async$DefaultEventHandler$$config.compressionCodec(), rawMessages);
                                    break;
                                }
                                this.$outer.debug((Function0<String>)((Object)new scala.Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$7 $outer;
                                    private final TopicAndPartition topicAndPartition$1;
                                    private final Seq messages$1;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString("Sending %d messages to %s with no compression as it is not in compressed.topics - %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.messages$1.size()), this.topicAndPartition$1, this.$outer.kafka$producer$async$DefaultEventHandler$$anonfun$$$outer().kafka$producer$async$DefaultEventHandler$$config.compressedTopics().toString()}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.topicAndPartition$1 = topicAndPartition$1;
                                        this.messages$1 = messages$1;
                                    }
                                }));
                                byteBufferMessageSet2 = new ByteBufferMessageSet(NoCompressionCodec$.MODULE$, rawMessages);
                                break;
                            }
                            case 0: {
                                this.$outer.debug((Function0<String>)((Object)new scala.Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$7 $outer;
                                    private final TopicAndPartition topicAndPartition$1;
                                    private final Seq messages$1;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString("Sending %d messages with compression codec %d to %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.messages$1.size()), BoxesRunTime.boxToInteger(this.$outer.kafka$producer$async$DefaultEventHandler$$anonfun$$$outer().kafka$producer$async$DefaultEventHandler$$config.compressionCodec().codec()), this.topicAndPartition$1}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.topicAndPartition$1 = topicAndPartition$1;
                                        this.messages$1 = messages$1;
                                    }
                                }));
                                byteBufferMessageSet2 = new ByteBufferMessageSet(this.$outer.kafka$producer$async$DefaultEventHandler$$config.compressionCodec(), rawMessages);
                            }
                        }
                        byteBufferMessageSet = byteBufferMessageSet2;
                    }
                    Tuple2<TopicAndPartition, ByteBufferMessageSet> tuple22 = new Tuple2<TopicAndPartition, ByteBufferMessageSet>(topicAndPartition, byteBufferMessageSet);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ DefaultEventHandler kafka$producer$async$DefaultEventHandler$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }), Map$.MODULE$.canBuildFrom());
        return var2_2;
    }

    @Override
    public void close() {
        if (this.producerPool() != null) {
            this.producerPool().close();
        }
    }

    public DefaultEventHandler(ProducerConfig config, Partitioner partitioner, Encoder<V> encoder2, Encoder<K> keyEncoder, ProducerPool producerPool, HashMap<String, TopicMetadata> topicPartitionInfos) {
        this.kafka$producer$async$DefaultEventHandler$$config = config;
        this.partitioner = partitioner;
        this.kafka$producer$async$DefaultEventHandler$$encoder = encoder2;
        this.kafka$producer$async$DefaultEventHandler$$keyEncoder = keyEncoder;
        this.producerPool = producerPool;
        this.topicPartitionInfos = topicPartitionInfos;
        Logging$class.$init$(this);
        String string2 = config.producerType();
        this.isSync = !("sync" != null ? !"sync".equals(string2) : string2 != null);
        this.correlationId = new AtomicInteger(0);
        this.brokerPartitionInfo = new BrokerPartitionInfo(config, producerPool, topicPartitionInfos);
        this.topicMetadataRefreshInterval = config.topicMetadataRefreshIntervalMs();
        this.lastTopicMetadataRefreshTime = 0L;
        this.kafka$producer$async$DefaultEventHandler$$topicMetadataToRefresh = Set$.MODULE$.empty();
        this.sendPartitionPerTopicCache = HashMap$.MODULE$.empty();
        this.kafka$producer$async$DefaultEventHandler$$producerStats = ProducerStatsRegistry$.MODULE$.getProducerStats(config.clientId());
        this.kafka$producer$async$DefaultEventHandler$$producerTopicStats = ProducerTopicStatsRegistry$.MODULE$.getProducerTopicStats(config.clientId());
    }
}

