/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.common.KafkaException;
import kafka.log.OffsetPosition;
import kafka.message.ByteBufferMessageSet;
import kafka.message.InvalidMessageException;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.utils.IteratorTemplate;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u0001\u0003\u0001\u001d\u0011aBR5mK6+7o]1hKN+GO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u000f5,7o]1hK&\u0011QB\u0003\u0002\u000b\u001b\u0016\u001c8/Y4f'\u0016$\bCA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011U\u0001!\u00111A\u0005\u0002Y\tAAZ5mKV\tq\u0003\u0005\u0002\u0019;5\t\u0011D\u0003\u0002\u001b7\u0005\u0011\u0011n\u001c\u0006\u00029\u0005!!.\u0019<b\u0013\tq\u0012D\u0001\u0003GS2,\u0007\u0002\u0003\u0011\u0001\u0005\u0003\u0007I\u0011A\u0011\u0002\u0011\u0019LG.Z0%KF$\"A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\tUs\u0017\u000e\u001e\u0005\bS}\t\t\u00111\u0001\u0018\u0003\rAH%\r\u0005\tW\u0001\u0011\t\u0011)Q\u0005/\u0005)a-\u001b7fA!\u0012!&\f\t\u0003G9J!a\f\u0013\u0003\u0011Y|G.\u0019;jY\u0016D\u0011\"\r\u0001\u0003\u0006\u0004%\tA\u0001\u001a\u0002\u000f\rD\u0017M\u001c8fYV\t1\u0007\u0005\u00025s5\tQG\u0003\u00027o\u0005A1\r[1o]\u0016d7O\u0003\u000297\u0005\u0019a.[8\n\u0005i*$a\u0003$jY\u0016\u001c\u0005.\u00198oK2D\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006IaM\u0001\tG\"\fgN\\3mA!Ia\b\u0001BC\u0002\u0013\u0005!aP\u0001\u0006gR\f'\u000f^\u000b\u0002\u0001B\u00111%Q\u0005\u0003\u0005\u0012\u00121!\u00138u\u0011!!\u0005A!A!\u0002\u0013\u0001\u0015AB:uCJ$\b\u0005C\u0005G\u0001\t\u0015\r\u0011\"\u0001\u0003\u007f\u0005\u0019QM\u001c3\t\u0011!\u0003!\u0011!Q\u0001\n\u0001\u000bA!\u001a8eA!A!\n\u0001B\u0001B\u0003%1*A\u0004jgNc\u0017nY3\u0011\u0005\rb\u0015BA'%\u0005\u001d\u0011un\u001c7fC:Daa\u0014\u0001\u0005\u0002\u0011\u0001\u0016A\u0002\u001fj]&$h\b\u0006\u0004R'R+fk\u0016\t\u0003%\u0002i\u0011A\u0001\u0005\u0006+9\u0003\ra\u0006\u0005\u0006c9\u0003\ra\r\u0005\u0006}9\u0003\r\u0001\u0011\u0005\u0006\r:\u0003\r\u0001\u0011\u0005\u0006\u0015:\u0003\ra\u0013\u0005\b3\u0002\u0011\r\u0011\"\u0003[\u0003\u0015y6/\u001b>f+\u0005Y\u0006C\u0001/d\u001b\u0005i&B\u00010`\u0003\u0019\tGo\\7jG*\u0011\u0001-Y\u0001\u000bG>t7-\u001e:sK:$(B\u00012\u001c\u0003\u0011)H/\u001b7\n\u0005\u0011l&!D!u_6L7-\u00138uK\u001e,'\u000f\u0003\u0004g\u0001\u0001\u0006IaW\u0001\u0007?NL'0\u001a\u0011\t\u000b=\u0003A\u0011\u00015\u0015\u0007EK'\u000eC\u0003\u0016O\u0002\u0007q\u0003C\u00032O\u0002\u00071\u0007C\u0003P\u0001\u0011\u0005A\u000e\u0006\u0002R[\")Qc\u001ba\u0001/!)q\n\u0001C\u0001_R\u0019\u0011\u000b]9\t\u000bUq\u0007\u0019A\f\t\u000bIt\u0007\u0019A&\u0002\u000f5,H/\u00192mK\")q\n\u0001C\u0001iR)\u0011+\u001e<xq\")Qc\u001da\u0001/!)\u0011g\u001da\u0001g!)ah\u001da\u0001\u0001\")ai\u001da\u0001\u0001\")!\u0010\u0001C\u0001w\u0006!!/Z1e)\r\tFP \u0005\u0006{f\u0004\r\u0001Q\u0001\ta>\u001c\u0018\u000e^5p]\")q0\u001fa\u0001\u0001\u0006!1/\u001b>f\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000b\t\u0011b]3be\u000eDgi\u001c:\u0015\r\u0005\u001d\u0011QBA\f!\r\u0011\u0016\u0011B\u0005\u0004\u0003\u0017\u0011!AD(gMN,G\u000fU8tSRLwN\u001c\u0005\t\u0003\u001f\t\t\u00011\u0001\u0002\u0012\u0005aA/\u0019:hKR|eMZ:fiB\u00191%a\u0005\n\u0007\u0005UAE\u0001\u0003M_:<\u0007bBA\r\u0003\u0003\u0001\r\u0001Q\u0001\u0011gR\f'\u000f^5oOB{7/\u001b;j_:Dq!!\b\u0001\t\u0003\ty\"A\u0004xe&$X\rV8\u0015\u000f\u0001\u000b\t#a\u000b\u00020!A\u00111EA\u000e\u0001\u0004\t)#A\u0006eKN$8\t[1o]\u0016d\u0007c\u0001\u001b\u0002(%\u0019\u0011\u0011F\u001b\u0003)\u001d\u000bG\u000f[3sS:<')\u001f;f\u0007\"\fgN\\3m\u0011!\ti#a\u0007A\u0002\u0005E\u0011!D<sSR,\u0007k\\:ji&|g\u000e\u0003\u0004\u0000\u00037\u0001\r\u0001\u0011\u0005\b\u0003g\u0001A\u0011IA\u001b\u0003!IG/\u001a:bi>\u0014HCAA\u001c!\u0019\tI$!\u0013\u0002P9!\u00111HA#\u001d\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!\r\u00051AH]8pizJ\u0011!J\u0005\u0004\u0003\u000f\"\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\niE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\t9\u0005\n\t\u0004\u0013\u0005E\u0013bAA*\u0015\t\u0001R*Z:tC\u001e,\u0017I\u001c3PM\u001a\u001cX\r\u001e\u0005\b\u0003g\u0001A\u0011AA,)\u0011\t9$!\u0017\t\u000f\u0005m\u0013Q\u000ba\u0001\u0001\u0006qQ.\u0019=NKN\u001c\u0018mZ3TSj,\u0007bBA0\u0001\u0011\u0005\u0011\u0011M\u0001\fg&TX-\u00138CsR,7\u000fF\u0001A\u0011\u001d\t)\u0007\u0001C\u0001\u0003O\na!\u00199qK:$Gc\u0001\u0012\u0002j!A\u00111NA2\u0001\u0004\ti'\u0001\u0005nKN\u001c\u0018mZ3t!\rI\u0011qN\u0005\u0004\u0003cR!\u0001\u0006\"zi\u0016\u0014UO\u001a4fe6+7o]1hKN+G\u000fC\u0004\u0002v\u0001!\t!a\u001e\u0002\u000b\u0019dWo\u001d5\u0015\u0003\tBq!a\u001f\u0001\t\u0003\t9(A\u0003dY>\u001cX\rC\u0004\u0002\u0000\u0001!\t!!!\u0002\r\u0011,G.\u001a;f)\u0005Y\u0005bBAC\u0001\u0011\u0005\u0011qQ\u0001\u000biJ,hnY1uKR{Gc\u0001!\u0002\n\"9\u00111RAB\u0001\u0004\u0001\u0015A\u0003;be\u001e,GoU5{K\"9\u0011q\u0012\u0001\u0005\u0002\u0005E\u0015\u0001\u0003:fC\u0012Le\u000e^8\u0015\r\u0005M\u00151TAP!\u0011\t)*a&\u000e\u0003]J1!!'8\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\t\u0003;\u000bi\t1\u0001\u0002\u0014\u00061!-\u001e4gKJDq!!)\u0002\u000e\u0002\u0007\u0001)\u0001\tsK2\fG/\u001b<f!>\u001c\u0018\u000e^5p]\"9\u0011Q\u0015\u0001\u0005\u0002\u0005\u001d\u0016\u0001\u0003:f]\u0006lW\rV8\u0015\u0007-\u000bI\u000bC\u0004\u0002,\u0006\r\u0006\u0019A\f\u0002\u0003\u0019D3\u0001AAX!\ry\u0011\u0011W\u0005\u0004\u0003g\u0003\"!\u00048p]RD'/Z1eg\u00064W\r")
public class FileMessageSet
extends MessageSet
implements Logging {
    private volatile File file;
    private final FileChannel channel;
    private final int start;
    private final int end;
    private final AtomicInteger _size;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        FileMessageSet fileMessageSet = this;
        synchronized (fileMessageSet) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public FileChannel channel() {
        return this.channel;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    private AtomicInteger _size() {
        return this._size;
    }

    public FileMessageSet read(int position, int size2) {
        if (position < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid position: ").append(BoxesRunTime.boxToInteger(position)).toString());
        }
        if (size2 < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid size: ").append(BoxesRunTime.boxToInteger(size2)).toString());
        }
        return new FileMessageSet(this.file(), this.channel(), this.start() + position, package$.MODULE$.min(this.start() + position + size2, this.sizeInBytes()));
    }

    public OffsetPosition searchFor(long targetOffset, int startingPosition) {
        int position = startingPosition;
        ByteBuffer buffer = ByteBuffer.allocate(MessageSet$.MODULE$.LogOverhead());
        int size2 = this.sizeInBytes();
        while (position + MessageSet$.MODULE$.LogOverhead() < size2) {
            buffer.rewind();
            this.channel().read(buffer, position);
            if (buffer.hasRemaining()) {
                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Failed to read complete buffer for targetOffset %d startPosition %d in %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(targetOffset), BoxesRunTime.boxToInteger(startingPosition), this.file().getAbsolutePath()})));
            }
            buffer.rewind();
            long offset = buffer.getLong();
            if (offset >= targetOffset) {
                return new OffsetPosition(offset, position);
            }
            int messageSize = buffer.getInt();
            if (messageSize < Message$.MODULE$.MessageOverhead()) {
                throw new IllegalStateException(new StringBuilder().append((Object)"Invalid message size: ").append(BoxesRunTime.boxToInteger(messageSize)).toString());
            }
            position += MessageSet$.MODULE$.LogOverhead() + messageSize;
        }
        return null;
    }

    @Override
    public int writeTo(GatheringByteChannel destChannel, long writePosition, int size2) {
        int newSize = package$.MODULE$.min((int)this.channel().size(), this.end()) - this.start();
        if (newSize < this._size().get()) {
            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Size of FileMessageSet %s has been truncated during write: old size %d, new size %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.file().getAbsolutePath(), BoxesRunTime.boxToInteger(this._size().get()), BoxesRunTime.boxToInteger(newSize)})));
        }
        int bytesTransferred = (int)this.channel().transferTo((long)this.start() + writePosition, package$.MODULE$.min(size2, this.sizeInBytes()), destChannel);
        this.trace((Function0<String>)((Object)new Serializable(this, size2, bytesTransferred){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileMessageSet $outer;
            private final int size$1;
            private final int bytesTransferred$1;

            public final String apply() {
                return new StringBuilder().append((Object)"FileMessageSet ").append((Object)this.$outer.file().getAbsolutePath()).append((Object)" : bytes transferred : ").append(BoxesRunTime.boxToInteger(this.bytesTransferred$1)).append((Object)" bytes requested for transfer : ").append(BoxesRunTime.boxToInteger(package$.MODULE$.min(this.size$1, this.$outer.sizeInBytes()))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.size$1 = size$1;
                this.bytesTransferred$1 = bytesTransferred$1;
            }
        }));
        return bytesTransferred;
    }

    @Override
    public Iterator<MessageAndOffset> iterator() {
        return this.iterator(Integer.MAX_VALUE);
    }

    public Iterator<MessageAndOffset> iterator(int maxMessageSize) {
        return new IteratorTemplate<MessageAndOffset>(this, maxMessageSize){
            private int location;
            private final ByteBuffer sizeOffsetBuffer;
            private final /* synthetic */ FileMessageSet $outer;
            private final int maxMessageSize$1;

            private int location() {
                return this.location;
            }

            private void location_$eq(int x$1) {
                this.location = x$1;
            }

            private ByteBuffer sizeOffsetBuffer() {
                return this.sizeOffsetBuffer;
            }

            public MessageAndOffset makeNext() {
                if (this.location() >= this.$outer.end()) {
                    return (MessageAndOffset)this.allDone();
                }
                this.sizeOffsetBuffer().rewind();
                this.$outer.channel().read(this.sizeOffsetBuffer(), this.location());
                if (this.sizeOffsetBuffer().hasRemaining()) {
                    return (MessageAndOffset)this.allDone();
                }
                this.sizeOffsetBuffer().rewind();
                long offset = this.sizeOffsetBuffer().getLong();
                int size2 = this.sizeOffsetBuffer().getInt();
                if (size2 < Message$.MODULE$.MinHeaderSize()) {
                    return (MessageAndOffset)this.allDone();
                }
                if (size2 > this.maxMessageSize$1) {
                    throw new InvalidMessageException(new StringOps(Predef$.MODULE$.augmentString("Message size exceeds the largest allowable message size (%d).")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.maxMessageSize$1)})));
                }
                ByteBuffer buffer = ByteBuffer.allocate(size2);
                this.$outer.channel().read(buffer, this.location() + 12);
                if (buffer.hasRemaining()) {
                    return (MessageAndOffset)this.allDone();
                }
                buffer.rewind();
                this.location_$eq(this.location() + (size2 + 12));
                return new MessageAndOffset(new Message(buffer), offset);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.maxMessageSize$1 = maxMessageSize$1;
                this.location = $outer.start();
                this.sizeOffsetBuffer = ByteBuffer.allocate(12);
            }
        };
    }

    @Override
    public int sizeInBytes() {
        return this._size().get();
    }

    public void append(ByteBufferMessageSet messages) {
        int written = messages.writeTo(this.channel(), 0L, messages.sizeInBytes());
        this._size().getAndAdd(written);
    }

    public void flush() {
        this.channel().force(true);
    }

    public void close() {
        this.flush();
        this.channel().close();
    }

    public boolean delete() {
        Utils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileMessageSet $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.channel().close();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        return this.file().delete();
    }

    public int truncateTo(int targetSize) {
        int originalSize = this.sizeInBytes();
        if (targetSize > originalSize || targetSize < 0) {
            throw new KafkaException(new StringBuilder().append((Object)"Attempt to truncate log segment to ").append(BoxesRunTime.boxToInteger(targetSize)).append((Object)" bytes failed, ").append((Object)" size of this log segment is ").append(BoxesRunTime.boxToInteger(originalSize)).append((Object)" bytes.").toString());
        }
        this.channel().truncate(targetSize);
        this.channel().position(targetSize);
        this._size().set(targetSize);
        return originalSize - targetSize;
    }

    public ByteBuffer readInto(ByteBuffer buffer, int relativePosition) {
        this.channel().read(buffer, relativePosition + this.start());
        buffer.flip();
        return buffer;
    }

    /*
     * WARNING - void declaration
     */
    public boolean renameTo(File f) {
        void var2_2;
        boolean success2 = this.file().renameTo(f);
        this.file_$eq(f);
        return (boolean)var2_2;
    }

    public FileMessageSet(File file, FileChannel channel, int start, int end, boolean isSlice) {
        this.file = file;
        this.channel = channel;
        this.start = start;
        this.end = end;
        Logging$class.$init$(this);
        this._size = isSlice ? new AtomicInteger(end - start) : new AtomicInteger(package$.MODULE$.min((int)channel.size(), end) - start);
        Object object = isSlice ? BoxedUnit.UNIT : channel.position(channel.size());
    }

    public FileMessageSet(File file, FileChannel channel) {
        this(file, channel, 0, Integer.MAX_VALUE, false);
    }

    public FileMessageSet(File file) {
        this(file, Utils$.MODULE$.openChannel(file, true));
    }

    public FileMessageSet(File file, boolean mutable) {
        this(file, Utils$.MODULE$.openChannel(file, mutable));
    }

    public FileMessageSet(File file, FileChannel channel, int start, int end) {
        this(file, channel, start, end, true);
    }
}

