/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import kafka.api.PartitionMetadata$;
import kafka.api.TopicMetadata$;
import kafka.cluster.Broker;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Product$class;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dx!B\u0001\u0003\u0011\u00039\u0011!\u0005)beRLG/[8o\u001b\u0016$\u0018\rZ1uC*\u00111\u0001B\u0001\u0004CBL'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\t\t\u0002+\u0019:uSRLwN\\'fi\u0006$\u0017\r^1\u0014\u0007%a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001bMI!\u0001\u0006\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000bYIA\u0011A\f\u0002\rqJg.\u001b;?)\u00059\u0001\"B\r\n\t\u0003Q\u0012\u0001\u0003:fC\u00124%o\\7\u0015\u000bm\ti*a(\u0011\u0005!ab\u0001\u0002\u0006\u0003\u0001v\u0019R\u0001\b\u0007\u001fII\u0001\"a\b\u0012\u000e\u0003\u0001R!!\t\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005\r\u0002#a\u0002'pO\u001eLgn\u001a\t\u0003\u001b\u0015J!A\n\b\u0003\u000fA\u0013x\u000eZ;di\"A\u0001\u0006\bBK\u0002\u0013\u0005\u0011&A\u0006qCJ$\u0018\u000e^5p]&#W#\u0001\u0016\u0011\u00055Y\u0013B\u0001\u0017\u000f\u0005\rIe\u000e\u001e\u0005\t]q\u0011\t\u0012)A\u0005U\u0005a\u0001/\u0019:uSRLwN\\%eA!A\u0001\u0007\bBK\u0002\u0013\u0005\u0011'\u0001\u0004mK\u0006$WM]\u000b\u0002eA\u0019QbM\u001b\n\u0005Qr!AB(qi&|g\u000e\u0005\u00027s5\tqG\u0003\u00029\t\u000591\r\\;ti\u0016\u0014\u0018B\u0001\u001e8\u0005\u0019\u0011%o\\6fe\"AA\b\bB\tB\u0003%!'A\u0004mK\u0006$WM\u001d\u0011\t\u0011yb\"Q3A\u0005\u0002}\n\u0001B]3qY&\u001c\u0017m]\u000b\u0002\u0001B\u0019\u0011)S\u001b\u000f\u0005\t;eBA\"G\u001b\u0005!%BA#\u0007\u0003\u0019a$o\\8u}%\tq\"\u0003\u0002I\u001d\u00059\u0001/Y2lC\u001e,\u0017B\u0001&L\u0005\r\u0019V-\u001d\u0006\u0003\u0011:A\u0001\"\u0014\u000f\u0003\u0012\u0003\u0006I\u0001Q\u0001\ne\u0016\u0004H.[2bg\u0002B\u0001b\u0014\u000f\u0003\u0016\u0004%\taP\u0001\u0004SN\u0014\b\u0002C)\u001d\u0005#\u0005\u000b\u0011\u0002!\u0002\t%\u001c(\u000f\t\u0005\t'r\u0011)\u001a!C\u0001)\u0006IQM\u001d:pe\u000e{G-Z\u000b\u0002+B\u0011QBV\u0005\u0003/:\u0011Qa\u00155peRD\u0001\"\u0017\u000f\u0003\u0012\u0003\u0006I!V\u0001\u000bKJ\u0014xN]\"pI\u0016\u0004\u0003\"\u0002\f\u001d\t\u0003YFCB\u000e];z{\u0006\rC\u0003)5\u0002\u0007!\u0006C\u000315\u0002\u0007!\u0007C\u0003?5\u0002\u0007\u0001\tC\u0004P5B\u0005\t\u0019\u0001!\t\u000fMS\u0006\u0013!a\u0001+\")!\r\bC\u0001S\u0005Y1/\u001b>f\u0013:\u0014\u0015\u0010^3t\u0011\u0015!G\u0004\"\u0001f\u0003\u001d9(/\u001b;f)>$\"AZ5\u0011\u000559\u0017B\u00015\u000f\u0005\u0011)f.\u001b;\t\u000b)\u001c\u0007\u0019A6\u0002\r\t,hMZ3s!\ta\u0017/D\u0001n\u0015\tqw.A\u0002oS>T\u0011\u0001]\u0001\u0005U\u00064\u0018-\u0003\u0002s[\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000bQdB\u0011I;\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A\u001e\t\u0003ojt!!\u0004=\n\u0005et\u0011A\u0002)sK\u0012,g-\u0003\u0002|y\n11\u000b\u001e:j]\u001eT!!\u001f\b\t\u000bydB\u0011B@\u0002\u0019\u0019|'/\\1u\u0005J|7.\u001a:\u0015\t\u0005\u0005\u00111\u0002\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011qA8\u0002\t1\fgnZ\u0005\u0004w\u0006\u0015\u0001BBA\u0007{\u0002\u0007Q'\u0001\u0004ce>\\WM\u001d\u0005\n\u0003#a\u0012\u0011!C\u0001\u0003'\tAaY8qsRY1$!\u0006\u0002\u0018\u0005e\u00111DA\u000f\u0011!A\u0013q\u0002I\u0001\u0002\u0004Q\u0003\u0002\u0003\u0019\u0002\u0010A\u0005\t\u0019\u0001\u001a\t\u0011y\ny\u0001%AA\u0002\u0001C\u0001bTA\b!\u0003\u0005\r\u0001\u0011\u0005\t'\u0006=\u0001\u0013!a\u0001+\"I\u0011\u0011\u0005\u000f\u0012\u0002\u0013\u0005\u00111E\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)CK\u0002+\u0003OY#!!\u000b\u0011\t\u0005-\u0012QG\u0007\u0003\u0003[QA!a\f\u00022\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003gq\u0011AC1o]>$\u0018\r^5p]&!\u0011qGA\u0017\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003wa\u0012\u0013!C\u0001\u0003{\tabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002@)\u001a!'a\n\t\u0013\u0005\rC$%A\u0005\u0002\u0005\u0015\u0013AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u000fR3\u0001QA\u0014\u0011%\tY\u0005HI\u0001\n\u0003\t)%\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\t\u0013\u0005=C$%A\u0005\u0002\u0005E\u0013AD2paf$C-\u001a4bk2$H%N\u000b\u0003\u0003'R3!VA\u0014\u0011%\t9\u0006HA\u0001\n\u0003\nI&A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0003A\u0001\"!\u0018\u001d\u0003\u0003%\t!K\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\n\u0003Cb\u0012\u0011!C\u0001\u0003G\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002f\u0005-\u0004cA\u0007\u0002h%\u0019\u0011\u0011\u000e\b\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002n\u0005}\u0013\u0011!a\u0001U\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005ED$!A\u0005B\u0005M\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005U\u0004CBA<\u0003{\n)'\u0004\u0002\u0002z)\u0019\u00111\u0010\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0000\u0005e$\u0001C%uKJ\fGo\u001c:\t\u0013\u0005\rE$!A\u0005\u0002\u0005\u0015\u0015\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u001d\u0015Q\u0012\t\u0004\u001b\u0005%\u0015bAAF\u001d\t9!i\\8mK\u0006t\u0007BCA7\u0003\u0003\u000b\t\u00111\u0001\u0002f!I\u0011\u0011\u0013\u000f\u0002\u0002\u0013\u0005\u00131S\u0001\tQ\u0006\u001c\bnQ8eKR\t!\u0006C\u0005\u0002\u0018r\t\t\u0011\"\u0011\u0002\u001a\u00061Q-];bYN$B!a\"\u0002\u001c\"Q\u0011QNAK\u0003\u0003\u0005\r!!\u001a\t\u000b)D\u0002\u0019A6\t\u000f\u0005\u0005\u0006\u00041\u0001\u0002$\u00069!M]8lKJ\u001c\b#B<\u0002&**\u0014bAATy\n\u0019Q*\u00199\t\u0013\u0005-\u0016\"!A\u0005\u0002\u00065\u0016!B1qa2LHcC\u000e\u00020\u0006E\u00161WA[\u0003oCa\u0001KAU\u0001\u0004Q\u0003B\u0002\u0019\u0002*\u0002\u0007!\u0007\u0003\u0004?\u0003S\u0003\r\u0001\u0011\u0005\t\u001f\u0006%\u0006\u0013!a\u0001\u0001\"A1+!+\u0011\u0002\u0003\u0007Q\u000bC\u0005\u0002<&\t\t\u0011\"!\u0002>\u00069QO\\1qa2LH\u0003BA`\u0003\u000f\u0004B!D\u001a\u0002BBAQ\"a1+e\u0001\u0003U+C\u0002\u0002F:\u0011a\u0001V;qY\u0016,\u0004\"CAe\u0003s\u000b\t\u00111\u0001\u001c\u0003\rAH\u0005\r\u0005\n\u0003\u001bL\u0011\u0013!C\u0001\u0003\u000b\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0004\"CAi\u0013E\u0005I\u0011AA)\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%k!I\u0011Q[\u0005\u0012\u0002\u0013\u0005\u0011QI\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%i!I\u0011\u0011\\\u0005\u0012\u0002\u0013\u0005\u0011\u0011K\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%k!I\u0011Q\\\u0005\u0002\u0002\u0013%\u0011q\\\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002bB!\u00111AAr\u0013\u0011\t)/!\u0002\u0003\r=\u0013'.Z2u\u0001")
public class PartitionMetadata
implements Logging,
Product,
Serializable {
    private final int partitionId;
    private final Option<Broker> leader;
    private final Seq<Broker> replicas;
    private final Seq<Broker> isr;
    private final short errorCode;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static short apply$default$5() {
        return PartitionMetadata$.MODULE$.apply$default$5();
    }

    public static Seq<Broker> apply$default$4() {
        return PartitionMetadata$.MODULE$.apply$default$4();
    }

    public static short $lessinit$greater$default$5() {
        return PartitionMetadata$.MODULE$.$lessinit$greater$default$5();
    }

    public static Seq<Broker> $lessinit$greater$default$4() {
        return PartitionMetadata$.MODULE$.$lessinit$greater$default$4();
    }

    public static PartitionMetadata readFrom(ByteBuffer byteBuffer, Map<Object, Broker> map2) {
        return PartitionMetadata$.MODULE$.readFrom(byteBuffer, map2);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        PartitionMetadata partitionMetadata = this;
        synchronized (partitionMetadata) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Option<Broker> leader() {
        return this.leader;
    }

    public Seq<Broker> replicas() {
        return this.replicas;
    }

    public Seq<Broker> isr() {
        return this.isr;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public int sizeInBytes() {
        return 14 + 4 * this.replicas().size() + 4 + 4 * this.isr().size();
    }

    public void writeTo(ByteBuffer buffer) {
        buffer.putShort(this.errorCode());
        buffer.putInt(this.partitionId());
        int leaderId = this.leader().isDefined() ? this.leader().get().id() : TopicMetadata$.MODULE$.NoLeaderNodeId();
        buffer.putInt(leaderId);
        buffer.putInt(this.replicas().size());
        this.replicas().foreach(new Serializable(this, buffer){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer buffer$4;

            public final ByteBuffer apply(Broker r) {
                return this.buffer$4.putInt(r.id());
            }
            {
                this.buffer$4 = buffer$4;
            }
        });
        buffer.putInt(this.isr().size());
        this.isr().foreach(new Serializable(this, buffer){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer buffer$4;

            public final ByteBuffer apply(Broker r) {
                return this.buffer$4.putInt(r.id());
            }
            {
                this.buffer$4 = buffer$4;
            }
        });
    }

    public String toString() {
        StringBuilder partitionMetadataString = new StringBuilder();
        partitionMetadataString.append(new StringBuilder().append((Object)"\tpartition ").append(BoxesRunTime.boxToInteger(this.partitionId())).toString());
        partitionMetadataString.append(new StringBuilder().append((Object)"\tleader: ").append((Object)(this.leader().isDefined() ? this.kafka$api$PartitionMetadata$$formatBroker(this.leader().get()) : "none")).toString());
        partitionMetadataString.append(new StringBuilder().append((Object)"\treplicas: ").append((Object)((TraversableOnce)this.replicas().map(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionMetadata $outer;

            public final String apply(Broker broker) {
                return this.$outer.kafka$api$PartitionMetadata$$formatBroker(broker);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",")).toString());
        partitionMetadataString.append(new StringBuilder().append((Object)"\tisr: ").append((Object)((TraversableOnce)this.isr().map(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionMetadata $outer;

            public final String apply(Broker broker) {
                return this.$outer.kafka$api$PartitionMetadata$$formatBroker(broker);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",")).toString());
        partitionMetadataString.append(new StringOps(Predef$.MODULE$.augmentString("\tisUnderReplicated: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.isr().size() < this.replicas().size() ? "true" : "false"})));
        return partitionMetadataString.toString();
    }

    public String kafka$api$PartitionMetadata$$formatBroker(Broker broker) {
        return new StringBuilder().append(broker.id()).append((Object)" (").append((Object)Utils.formatAddress(broker.host(), Predef$.MODULE$.int2Integer(broker.port()))).append((Object)")").toString();
    }

    public PartitionMetadata copy(int partitionId, Option<Broker> leader, Seq<Broker> replicas, Seq<Broker> isr, short errorCode) {
        return new PartitionMetadata(partitionId, leader, replicas, isr, errorCode);
    }

    public int copy$default$1() {
        return this.partitionId();
    }

    public Option<Broker> copy$default$2() {
        return this.leader();
    }

    public Seq<Broker> copy$default$3() {
        return this.replicas();
    }

    public Seq<Broker> copy$default$4() {
        return this.isr();
    }

    public short copy$default$5() {
        return this.errorCode();
    }

    @Override
    public String productPrefix() {
        return "PartitionMetadata";
    }

    @Override
    public int productArity() {
        return 5;
    }

    @Override
    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
            }
            case 4: {
                object = BoxesRunTime.boxToShort(this.errorCode());
                break;
            }
            case 3: {
                object = this.isr();
                break;
            }
            case 2: {
                object = this.replicas();
                break;
            }
            case 1: {
                object = this.leader();
                break;
            }
            case 0: {
                object = BoxesRunTime.boxToInteger(this.partitionId());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator(this);
    }

    @Override
    public boolean canEqual(Object x$1) {
        return x$1 instanceof PartitionMetadata;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, this.partitionId());
        n = Statics.mix(n, Statics.anyHash(this.leader()));
        n = Statics.mix(n, Statics.anyHash(this.replicas()));
        n = Statics.mix(n, Statics.anyHash(this.isr()));
        n = Statics.mix(n, this.errorCode());
        return Statics.finalizeHash(n, 5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PartitionMetadata)) return false;
        boolean bl = true;
        if (!bl) return false;
        PartitionMetadata partitionMetadata = (PartitionMetadata)x$1;
        if (this.partitionId() != partitionMetadata.partitionId()) return false;
        Option<Broker> option = this.leader();
        Option<Broker> option2 = partitionMetadata.leader();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Seq<Broker> seq = this.replicas();
        Seq<Broker> seq2 = partitionMetadata.replicas();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Seq<Broker> seq3 = this.isr();
        Seq<Broker> seq4 = partitionMetadata.isr();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        if (this.errorCode() != partitionMetadata.errorCode()) return false;
        if (!partitionMetadata.canEqual(this)) return false;
        return true;
    }

    public PartitionMetadata(int partitionId, Option<Broker> leader, Seq<Broker> replicas, Seq<Broker> isr, short errorCode) {
        this.partitionId = partitionId;
        this.leader = leader;
        this.replicas = replicas;
        this.isr = isr;
        this.errorCode = errorCode;
        Logging$class.$init$(this);
        Product$class.$init$(this);
    }
}

