/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.utils.DelayedExecutor;

public final class SilentConnectionFilter
extends BaseFilter {
    private static final Logger LOGGER = Grizzly.logger(SilentConnectionFilter.class);
    public static final long UNLIMITED_TIMEOUT = -1L;
    public static final long UNSET_TIMEOUT = 0L;
    private static final String ATTR_NAME = SilentConnectionFilter.class.getName() + ".silent-connection-attr";
    private static final Attribute<Long> silentConnectionAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(ATTR_NAME);
    private final long timeoutMillis;
    private final DelayedExecutor.DelayQueue<Connection> queue;

    public SilentConnectionFilter(DelayedExecutor executor, long timeout, TimeUnit timeunit) {
        this.timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
        this.queue = executor.createDelayQueue(new DelayedExecutor.Worker<Connection>(){

            @Override
            public boolean doWork(Connection connection) {
                try {
                    connection.close().markForRecycle(true);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "SilentConnectionFilter:unexpected exception, when trying to close connection", e);
                }
                return true;
            }
        }, new Resolver());
    }

    public long getTimeout(TimeUnit timeunit) {
        return timeunit.convert(this.timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public NextAction handleAccept(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        this.queue.add(connection, this.timeoutMillis, TimeUnit.MILLISECONDS);
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        this.queue.remove(connection);
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        this.queue.remove(connection);
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        this.queue.remove(ctx.getConnection());
        return ctx.getInvokeAction();
    }

    private static final class Resolver
    implements DelayedExecutor.Resolver<Connection> {
        private Resolver() {
        }

        @Override
        public boolean removeTimeout(Connection connection) {
            return silentConnectionAttr.remove(connection) != null;
        }

        @Override
        public Long getTimeoutMillis(Connection connection) {
            return (Long)silentConnectionAttr.get(connection);
        }

        @Override
        public void setTimeoutMillis(Connection connection, long timeoutMillis) {
            silentConnectionAttr.set(connection, Long.valueOf(timeoutMillis));
        }
    }
}

