/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memory;

import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Appender;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.memory.ByteBufferArray;
import org.glassfish.grizzly.memory.ByteBufferWrapper;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.memory.WrapperAware;

public class Buffers {
    private static final Logger LOGGER = Grizzly.logger(Buffers.class);
    public static final Appender<Buffer> BUFFER_APPENDER = new Appender<Buffer>(){

        @Override
        public Buffer append(Buffer element1, Buffer element2) {
            if (element1.isComposite()) {
                ((CompositeBuffer)element1).append(element2);
                return element1;
            }
            CompositeBuffer compositeBuffer = CompositeBuffer.newBuffer(null, element1);
            compositeBuffer.append(element2);
            return compositeBuffer;
        }
    };
    public static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
    public static final ByteBuffer[] EMPTY_BYTE_BUFFER_ARRAY = new ByteBuffer[0];
    public static final Buffer EMPTY_BUFFER = new ByteBufferWrapper(ByteBuffer.allocate(0).asReadOnlyBuffer()){

        @Override
        public void dispose() {
        }
    };

    public static Buffer wrap(MemoryManager memoryManager, String s2) {
        return Buffers.wrap(memoryManager, s2, Charset.defaultCharset());
    }

    public static Buffer wrap(MemoryManager memoryManager, String s2, Charset charset) {
        try {
            byte[] byteRepresentation = s2.getBytes(charset.name());
            return Buffers.wrap(memoryManager, byteRepresentation);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Buffer wrap(MemoryManager memoryManager, byte[] array) {
        return Buffers.wrap(memoryManager, array, 0, array.length);
    }

    public static Buffer wrap(MemoryManager memoryManager, byte[] array, int offset, int length) {
        if (memoryManager == null) {
            memoryManager = Buffers.getDefaultMemoryManager();
        }
        if (memoryManager instanceof WrapperAware) {
            return ((WrapperAware)((Object)memoryManager)).wrap(array, offset, length);
        }
        Object buffer = memoryManager.allocate(length);
        buffer.put(array, offset, length);
        buffer.flip();
        return buffer;
    }

    public static Buffer wrap(MemoryManager memoryManager, ByteBuffer byteBuffer) {
        if (memoryManager instanceof WrapperAware) {
            return ((WrapperAware)((Object)memoryManager)).wrap(byteBuffer);
        }
        if (byteBuffer.hasArray()) {
            return Buffers.wrap(memoryManager, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        }
        throw new IllegalStateException("Can not wrap ByteBuffer");
    }

    public static ByteBuffer slice(ByteBuffer chunk, int size2) {
        chunk.limit(chunk.position() + size2);
        ByteBuffer view = chunk.slice();
        chunk.position(chunk.limit());
        chunk.limit(chunk.capacity());
        return view;
    }

    public static ByteBuffer slice(ByteBuffer byteBuffer, int position, int limit) {
        int oldPos = byteBuffer.position();
        int oldLimit = byteBuffer.limit();
        Buffers.setPositionLimit(byteBuffer, position, limit);
        ByteBuffer slice2 = byteBuffer.slice();
        Buffers.setPositionLimit(byteBuffer, oldPos, oldLimit);
        return slice2;
    }

    public static String toStringContent(ByteBuffer byteBuffer, Charset charset, int position, int limit) {
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        if (byteBuffer.hasArray()) {
            try {
                return new String(byteBuffer.array(), position + byteBuffer.arrayOffset(), limit - position, charset.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("We took charset name from Charset, why it's not unsupported?", e);
            }
        }
        int oldPosition = byteBuffer.position();
        int oldLimit = byteBuffer.limit();
        Buffers.setPositionLimit(byteBuffer, position, limit);
        byte[] tmpBuffer = new byte[limit - position];
        byteBuffer.get(tmpBuffer);
        Buffers.setPositionLimit(byteBuffer, oldPosition, oldLimit);
        try {
            return new String(tmpBuffer, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void setPositionLimit(Buffer buffer, int position, int limit) {
        buffer.limit(limit);
        buffer.position(position);
    }

    public static void setPositionLimit(ByteBuffer buffer, int position, int limit) {
        buffer.limit(limit);
        buffer.position(position);
    }

    public static void put(ByteBuffer srcBuffer, int srcOffset, int length, ByteBuffer dstBuffer) {
        if (dstBuffer.remaining() < length) {
            LOGGER.log(Level.WARNING, "BufferOverflow srcBuffer={0} srcOffset={1} length={2} dstBuffer={3}", new Object[]{srcBuffer, srcOffset, length, dstBuffer});
            throw new BufferOverflowException();
        }
        if (srcBuffer.hasArray() && dstBuffer.hasArray()) {
            System.arraycopy(srcBuffer.array(), srcBuffer.arrayOffset() + srcOffset, dstBuffer.array(), dstBuffer.arrayOffset() + dstBuffer.position(), length);
            dstBuffer.position(dstBuffer.position() + length);
        } else {
            for (int i = srcOffset; i < srcOffset + length; ++i) {
                dstBuffer.put(srcBuffer.get(i));
            }
        }
    }

    public static void put(Buffer src, int position, int length, Buffer dstBuffer) {
        if (dstBuffer.remaining() < length) {
            throw new BufferOverflowException();
        }
        if (!src.isComposite()) {
            ByteBuffer srcByteBuffer = src.toByteBuffer();
            if (srcByteBuffer.hasArray()) {
                dstBuffer.put(srcByteBuffer.array(), srcByteBuffer.arrayOffset() + position, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dstBuffer.put(srcByteBuffer.get(position + i));
                }
            }
        } else {
            ByteBufferArray array = src.toByteBufferArray(position, position + length);
            ByteBuffer[] srcByteBuffers = (ByteBuffer[])array.getArray();
            for (int i = 0; i < array.size(); ++i) {
                ByteBuffer srcByteBuffer = srcByteBuffers[i];
                int initialPosition = srcByteBuffer.position();
                int srcByteBufferLen = srcByteBuffer.remaining();
                if (srcByteBuffer.hasArray()) {
                    dstBuffer.put(srcByteBuffer.array(), srcByteBuffer.arrayOffset() + initialPosition, srcByteBufferLen);
                    continue;
                }
                int j = 0;
                while (j < srcByteBufferLen) {
                    dstBuffer.put(srcByteBuffer.get(initialPosition + j));
                    ++i;
                }
            }
            array.restore();
            array.recycle();
        }
    }

    public static void get(ByteBuffer srcBuffer, byte[] dstBytes, int dstOffset, int length) {
        if (srcBuffer.hasArray()) {
            if (length > srcBuffer.remaining()) {
                throw new BufferUnderflowException();
            }
            System.arraycopy(srcBuffer.array(), srcBuffer.arrayOffset() + srcBuffer.position(), dstBytes, dstOffset, length);
            srcBuffer.position(srcBuffer.position() + length);
        } else {
            srcBuffer.get(dstBytes, dstOffset, length);
        }
    }

    public static void put(byte[] srcBytes, int srcOffset, int length, ByteBuffer dstBuffer) {
        if (dstBuffer.hasArray()) {
            if (length > dstBuffer.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(srcBytes, srcOffset, dstBuffer.array(), dstBuffer.arrayOffset() + dstBuffer.position(), length);
            dstBuffer.position(dstBuffer.position() + length);
        } else {
            dstBuffer.put(srcBytes, srcOffset, length);
        }
    }

    public static Buffer appendBuffers(MemoryManager memoryManager, Buffer buffer1, Buffer buffer2) {
        if (buffer1 == null) {
            return buffer2;
        }
        if (buffer2 == null) {
            return buffer1;
        }
        if (buffer1.isComposite()) {
            ((CompositeBuffer)buffer1).append(buffer2);
            return buffer1;
        }
        if (buffer2.isComposite()) {
            ((CompositeBuffer)buffer2).prepend(buffer1);
            return buffer2;
        }
        CompositeBuffer compositeBuffer = CompositeBuffer.newBuffer(memoryManager);
        compositeBuffer.append(buffer1);
        compositeBuffer.append(buffer2);
        return compositeBuffer;
    }

    public static void fill(Buffer buffer, byte b) {
        Buffers.fill(buffer, buffer.position(), buffer.limit(), b);
    }

    public static void fill(Buffer buffer, int position, int limit, byte b) {
        if (!buffer.isComposite()) {
            ByteBuffer byteBuffer = buffer.toByteBuffer();
            Buffers.fill(byteBuffer, position, limit, b);
        } else {
            ByteBufferArray array = buffer.toByteBufferArray(position, limit);
            ByteBuffer[] byteBuffers = (ByteBuffer[])array.getArray();
            int size2 = array.size();
            for (int i = 0; i < size2; ++i) {
                ByteBuffer byteBuffer = byteBuffers[i];
                Buffers.fill(byteBuffer, b);
            }
            array.restore();
            array.recycle();
        }
    }

    public static void fill(ByteBuffer byteBuffer, byte b) {
        Buffers.fill(byteBuffer, byteBuffer.position(), byteBuffer.limit(), b);
    }

    public static void fill(ByteBuffer byteBuffer, int position, int limit, byte b) {
        if (byteBuffer.hasArray()) {
            int arrayOffset = byteBuffer.arrayOffset();
            Arrays.fill(byteBuffer.array(), arrayOffset + position, arrayOffset + limit, b);
        } else {
            for (int i = position; i < limit; ++i) {
                byteBuffer.put(i, b);
            }
        }
    }

    public static Buffer cloneBuffer(Buffer srcBuffer) {
        return Buffers.cloneBuffer(srcBuffer, srcBuffer.position(), srcBuffer.limit());
    }

    public static Buffer cloneBuffer(Buffer srcBuffer, int position, int limit) {
        int srcLength = limit - position;
        Object clone2 = Buffers.getDefaultMemoryManager().allocate(srcLength);
        clone2.put(srcBuffer, position, srcLength);
        return clone2.flip();
    }

    private static MemoryManager getDefaultMemoryManager() {
        return MemoryManager.DEFAULT_MEMORY_MANAGER;
    }
}

