/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;

public final class Cluster {
    private final List<Node> nodes;
    private final Map<TopicPartition, PartitionInfo> partitionsByTopicPartition;
    private final Map<String, List<PartitionInfo>> partitionsByTopic;
    private final Map<String, List<PartitionInfo>> availablePartitionsByTopic;
    private final Map<Integer, List<PartitionInfo>> partitionsByNode;

    public Cluster(Collection<Node> nodes, Collection<PartitionInfo> partitions) {
        ArrayList<Node> copy = new ArrayList<Node>(nodes);
        Collections.shuffle(copy);
        this.nodes = Collections.unmodifiableList(copy);
        this.partitionsByTopicPartition = new HashMap<TopicPartition, PartitionInfo>(partitions.size());
        for (PartitionInfo p : partitions) {
            this.partitionsByTopicPartition.put(new TopicPartition(p.topic(), p.partition()), p);
        }
        HashMap partsForTopic = new HashMap();
        HashMap partsForNode = new HashMap();
        for (Node node : this.nodes) {
            partsForNode.put(node.id(), new ArrayList());
        }
        for (PartitionInfo partitionInfo : partitions) {
            if (!partsForTopic.containsKey(partitionInfo.topic())) {
                partsForTopic.put(partitionInfo.topic(), new ArrayList());
            }
            List psTopic = (List)partsForTopic.get(partitionInfo.topic());
            psTopic.add(partitionInfo);
            if (partitionInfo.leader() == null) continue;
            List psNode = (List)Utils.notNull(partsForNode.get(partitionInfo.leader().id()));
            psNode.add(partitionInfo);
        }
        this.partitionsByTopic = new HashMap<String, List<PartitionInfo>>(partsForTopic.size());
        this.availablePartitionsByTopic = new HashMap<String, List<PartitionInfo>>(partsForTopic.size());
        for (Map.Entry entry2 : partsForTopic.entrySet()) {
            String topic = (String)entry2.getKey();
            List partitionList = (List)entry2.getValue();
            this.partitionsByTopic.put(topic, Collections.unmodifiableList(partitionList));
            ArrayList<PartitionInfo> availablePartitions = new ArrayList<PartitionInfo>();
            for (PartitionInfo part : partitionList) {
                if (part.leader() == null) continue;
                availablePartitions.add(part);
            }
            this.availablePartitionsByTopic.put(topic, Collections.unmodifiableList(availablePartitions));
        }
        this.partitionsByNode = new HashMap<Integer, List<PartitionInfo>>(partsForNode.size());
        for (Map.Entry entry3 : partsForNode.entrySet()) {
            this.partitionsByNode.put((Integer)entry3.getKey(), Collections.unmodifiableList((List)entry3.getValue()));
        }
    }

    public static Cluster empty() {
        return new Cluster(new ArrayList<Node>(0), new ArrayList<PartitionInfo>(0));
    }

    public static Cluster bootstrap(List<InetSocketAddress> addresses) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        int nodeId = -1;
        for (InetSocketAddress address : addresses) {
            nodes.add(new Node(nodeId--, address.getHostName(), address.getPort()));
        }
        return new Cluster(nodes, new ArrayList<PartitionInfo>(0));
    }

    public List<Node> nodes() {
        return this.nodes;
    }

    public Node leaderFor(TopicPartition topicPartition) {
        PartitionInfo info = this.partitionsByTopicPartition.get(topicPartition);
        if (info == null) {
            return null;
        }
        return info.leader();
    }

    public PartitionInfo partition(TopicPartition topicPartition) {
        return this.partitionsByTopicPartition.get(topicPartition);
    }

    public List<PartitionInfo> partitionsForTopic(String topic) {
        return this.partitionsByTopic.get(topic);
    }

    public List<PartitionInfo> availablePartitionsForTopic(String topic) {
        return this.availablePartitionsByTopic.get(topic);
    }

    public List<PartitionInfo> partitionsForNode(int nodeId) {
        return this.partitionsByNode.get(nodeId);
    }

    public Set<String> topics() {
        return this.partitionsByTopic.keySet();
    }

    public String toString() {
        return "Cluster(nodes = " + this.nodes + ", partitions = " + this.partitionsByTopicPartition.values() + ")";
    }
}

