/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DefaultResourceCalculator
extends ResourceCalculator {
    @Override
    public int compare(Resource unused, Resource lhs, Resource rhs) {
        return lhs.getMemory() - rhs.getMemory();
    }

    @Override
    public int computeAvailableContainers(Resource available, Resource required) {
        return available.getMemory() / required.getMemory();
    }

    @Override
    public float divide(Resource unused, Resource numerator, Resource denominator) {
        return this.ratio(numerator, denominator);
    }

    @Override
    public float ratio(Resource a, Resource b) {
        return (float)a.getMemory() / (float)b.getMemory();
    }

    @Override
    public Resource divideAndCeil(Resource numerator, int denominator) {
        return Resources.createResource(DefaultResourceCalculator.divideAndCeil(numerator.getMemory(), denominator));
    }

    @Override
    public Resource normalize(Resource r, Resource minimumResource, Resource maximumResource, Resource stepFactor) {
        int normalizedMemory = Math.min(DefaultResourceCalculator.roundUp(Math.max(r.getMemory(), minimumResource.getMemory()), stepFactor.getMemory()), maximumResource.getMemory());
        return Resources.createResource(normalizedMemory);
    }

    @Override
    public Resource normalize(Resource r, Resource minimumResource, Resource maximumResource) {
        return this.normalize(r, minimumResource, maximumResource, minimumResource);
    }

    @Override
    public Resource roundUp(Resource r, Resource stepFactor) {
        return Resources.createResource(DefaultResourceCalculator.roundUp(r.getMemory(), stepFactor.getMemory()));
    }

    @Override
    public Resource roundDown(Resource r, Resource stepFactor) {
        return Resources.createResource(DefaultResourceCalculator.roundDown(r.getMemory(), stepFactor.getMemory()));
    }

    @Override
    public Resource multiplyAndNormalizeUp(Resource r, double by2, Resource stepFactor) {
        return Resources.createResource(DefaultResourceCalculator.roundUp((int)((double)r.getMemory() * by2 + 0.5), stepFactor.getMemory()));
    }

    @Override
    public Resource multiplyAndNormalizeDown(Resource r, double by2, Resource stepFactor) {
        return Resources.createResource(DefaultResourceCalculator.roundDown((int)((double)r.getMemory() * by2), stepFactor.getMemory()));
    }
}

