/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ContainerTokenSelector
implements TokenSelector<ContainerTokenIdentifier> {
    private static final Log LOG = LogFactory.getLog(ContainerTokenSelector.class);

    @Override
    public Token<ContainerTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        for (Token<? extends TokenIdentifier> token2 : tokens) {
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)("Looking for service: " + service + ". Current token is " + token2));
            }
            if (!ContainerTokenIdentifier.KIND.equals(token2.getKind()) || !service.equals(token2.getService())) continue;
            return token2;
        }
        return null;
    }
}

