/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.text.NumberFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ApplicationId
implements Comparable<ApplicationId> {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String appIdStrPrefix = "application_";
    static final ThreadLocal<NumberFormat> appIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(4);
            return fmt;
        }
    };

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ApplicationId newInstance(long clusterTimestamp, int id) {
        ApplicationId appId = Records.newRecord(ApplicationId.class);
        appId.setClusterTimestamp(clusterTimestamp);
        appId.setId(id);
        appId.build();
        return appId;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setId(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract long getClusterTimestamp();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setClusterTimestamp(long var1);

    protected abstract void build();

    @Override
    public int compareTo(ApplicationId other) {
        if (this.getClusterTimestamp() - other.getClusterTimestamp() == 0L) {
            return this.getId() - other.getId();
        }
        return this.getClusterTimestamp() > other.getClusterTimestamp() ? 1 : (this.getClusterTimestamp() < other.getClusterTimestamp() ? -1 : 0);
    }

    public String toString() {
        return appIdStrPrefix + this.getClusterTimestamp() + "_" + appIdFormat.get().format(this.getId());
    }

    public int hashCode() {
        int prime = 371237;
        int result2 = 6521;
        long clusterTimestamp = this.getClusterTimestamp();
        result2 = 371237 * result2 + (int)(clusterTimestamp ^ clusterTimestamp >>> 32);
        result2 = 371237 * result2 + this.getId();
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationId other = (ApplicationId)obj;
        if (this.getClusterTimestamp() != other.getClusterTimestamp()) {
            return false;
        }
        return this.getId() == other.getId();
    }
}

