/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableGauge;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MutableGaugeLong
extends MutableGauge {
    private volatile long value;

    MutableGaugeLong(MetricsInfo info, long initValue) {
        super(info);
        this.value = initValue;
    }

    public long value() {
        return this.value;
    }

    @Override
    public synchronized void incr() {
        ++this.value;
        this.setChanged();
    }

    public synchronized void incr(long delta) {
        this.value += delta;
        this.setChanged();
    }

    @Override
    public synchronized void decr() {
        --this.value;
        this.setChanged();
    }

    public synchronized void decr(long delta) {
        this.value -= delta;
        this.setChanged();
    }

    public void set(long value2) {
        this.value = value2;
        this.setChanged();
    }

    @Override
    public void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            builder.addGauge(this.info(), this.value);
            this.clearChanged();
        }
    }
}

