/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.db.DBConfiguration;
import org.apache.hadoop.mapreduce.lib.db.DBInputFormat;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class DBRecordReader<T extends DBWritable>
extends RecordReader<LongWritable, T> {
    private static final Log LOG = LogFactory.getLog(DBRecordReader.class);
    private ResultSet results = null;
    private Class<T> inputClass;
    private Configuration conf;
    private DBInputFormat.DBInputSplit split;
    private long pos = 0L;
    private LongWritable key = null;
    private T value = null;
    private Connection connection;
    protected PreparedStatement statement;
    private DBConfiguration dbConf;
    private String conditions;
    private String[] fieldNames;
    private String tableName;

    public DBRecordReader(DBInputFormat.DBInputSplit split2, Class<T> inputClass, Configuration conf, Connection conn, DBConfiguration dbConfig, String cond, String[] fields, String table) throws SQLException {
        this.inputClass = inputClass;
        this.split = split2;
        this.conf = conf;
        this.connection = conn;
        this.dbConf = dbConfig;
        this.conditions = cond;
        this.fieldNames = fields;
        this.tableName = table;
    }

    protected ResultSet executeQuery(String query) throws SQLException {
        this.statement = this.connection.prepareStatement(query, 1003, 1007);
        return this.statement.executeQuery();
    }

    protected String getSelectQuery() {
        StringBuilder query = new StringBuilder();
        if (this.dbConf.getInputQuery() == null) {
            String orderBy;
            query.append("SELECT ");
            for (int i = 0; i < this.fieldNames.length; ++i) {
                query.append(this.fieldNames[i]);
                if (i == this.fieldNames.length - 1) continue;
                query.append(", ");
            }
            query.append(" FROM ").append(this.tableName);
            query.append(" AS ").append(this.tableName);
            if (this.conditions != null && this.conditions.length() > 0) {
                query.append(" WHERE (").append(this.conditions).append(")");
            }
            if ((orderBy = this.dbConf.getInputOrderBy()) != null && orderBy.length() > 0) {
                query.append(" ORDER BY ").append(orderBy);
            }
        } else {
            query.append(this.dbConf.getInputQuery());
        }
        try {
            query.append(" LIMIT ").append(this.split.getLength());
            query.append(" OFFSET ").append(this.split.getStart());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return query.toString();
    }

    @Override
    public void close() throws IOException {
        try {
            if (null != this.results) {
                this.results.close();
            }
            if (null != this.statement) {
                this.statement.close();
            }
            if (null != this.connection) {
                this.connection.commit();
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void initialize(InputSplit split2, TaskAttemptContext context) throws IOException, InterruptedException {
    }

    @Override
    public LongWritable getCurrentKey() {
        return this.key;
    }

    @Override
    public T getCurrentValue() {
        return this.value;
    }

    @Deprecated
    public T createValue() {
        return (T)((DBWritable)ReflectionUtils.newInstance(this.inputClass, this.conf));
    }

    @Deprecated
    public long getPos() throws IOException {
        return this.pos;
    }

    @Deprecated
    public boolean next(LongWritable key, T value2) throws IOException {
        this.key = key;
        this.value = value2;
        return this.nextKeyValue();
    }

    @Override
    public float getProgress() throws IOException {
        return (float)this.pos / (float)this.split.getLength();
    }

    @Override
    public boolean nextKeyValue() throws IOException {
        try {
            if (this.key == null) {
                this.key = new LongWritable();
            }
            if (this.value == null) {
                this.value = this.createValue();
            }
            if (null == this.results) {
                this.results = this.executeQuery(this.getSelectQuery());
            }
            if (!this.results.next()) {
                return false;
            }
            this.key.set(this.pos + this.split.getStart());
            this.value.readFields(this.results);
            ++this.pos;
        }
        catch (SQLException e) {
            throw new IOException("SQLException in nextKeyValue", e);
        }
        return true;
    }

    protected DBInputFormat.DBInputSplit getSplit() {
        return this.split;
    }

    protected String[] getFieldNames() {
        return this.fieldNames;
    }

    protected String getTableName() {
        return this.tableName;
    }

    protected String getConditions() {
        return this.conditions;
    }

    protected DBConfiguration getDBConf() {
        return this.dbConf;
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected PreparedStatement getStatement() {
        return this.statement;
    }

    protected void setStatement(PreparedStatement stmt) {
        this.statement = stmt;
    }
}

