/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HtmlQuoting {
    private static final byte[] ampBytes = "&amp;".getBytes();
    private static final byte[] aposBytes = "&apos;".getBytes();
    private static final byte[] gtBytes = "&gt;".getBytes();
    private static final byte[] ltBytes = "&lt;".getBytes();
    private static final byte[] quotBytes = "&quot;".getBytes();

    public static boolean needsQuoting(byte[] data2, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            switch (data2[i]) {
                case 34: 
                case 38: 
                case 39: 
                case 60: 
                case 62: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean needsQuoting(String str) {
        if (str == null) {
            return false;
        }
        byte[] bytes = str.getBytes();
        return HtmlQuoting.needsQuoting(bytes, 0, bytes.length);
    }

    public static void quoteHtmlChars(OutputStream output, byte[] buffer, int off, int len) throws IOException {
        block7: for (int i = off; i < off + len; ++i) {
            switch (buffer[i]) {
                case 38: {
                    output.write(ampBytes);
                    continue block7;
                }
                case 60: {
                    output.write(ltBytes);
                    continue block7;
                }
                case 62: {
                    output.write(gtBytes);
                    continue block7;
                }
                case 39: {
                    output.write(aposBytes);
                    continue block7;
                }
                case 34: {
                    output.write(quotBytes);
                    continue block7;
                }
                default: {
                    output.write(buffer, i, 1);
                }
            }
        }
    }

    public static String quoteHtmlChars(String item) {
        if (item == null) {
            return null;
        }
        byte[] bytes = item.getBytes();
        if (HtmlQuoting.needsQuoting(bytes, 0, bytes.length)) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try {
                HtmlQuoting.quoteHtmlChars(buffer, bytes, 0, bytes.length);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return buffer.toString();
        }
        return item;
    }

    public static OutputStream quoteOutputStream(final OutputStream out) throws IOException {
        return new OutputStream(){
            private byte[] data = new byte[1];

            @Override
            public void write(byte[] data2, int off, int len) throws IOException {
                HtmlQuoting.quoteHtmlChars(out, data2, off, len);
            }

            @Override
            public void write(int b) throws IOException {
                this.data[0] = (byte)b;
                HtmlQuoting.quoteHtmlChars(out, this.data, 0, 1);
            }

            @Override
            public void flush() throws IOException {
                out.flush();
            }

            @Override
            public void close() throws IOException {
                out.close();
            }
        };
    }

    public static String unquoteHtmlChars(String item) {
        if (item == null) {
            return null;
        }
        int next2 = item.indexOf(38);
        if (next2 == -1) {
            return item;
        }
        int len = item.length();
        int posn = 0;
        StringBuilder buffer = new StringBuilder();
        while (next2 != -1) {
            buffer.append(item.substring(posn, next2));
            if (item.startsWith("&amp;", next2)) {
                buffer.append('&');
                next2 += 5;
            } else if (item.startsWith("&apos;", next2)) {
                buffer.append('\'');
                next2 += 6;
            } else if (item.startsWith("&gt;", next2)) {
                buffer.append('>');
                next2 += 4;
            } else if (item.startsWith("&lt;", next2)) {
                buffer.append('<');
                next2 += 4;
            } else if (item.startsWith("&quot;", next2)) {
                buffer.append('\"');
                next2 += 6;
            } else {
                int end = item.indexOf(59, next2) + 1;
                if (end == 0) {
                    end = len;
                }
                throw new IllegalArgumentException("Bad HTML quoting for " + item.substring(next2, end));
            }
            posn = next2;
            next2 = item.indexOf(38, posn);
        }
        buffer.append(item.substring(posn, len));
        return buffer.toString();
    }

    public static void main(String[] args) throws Exception {
        for (String arg : args) {
            System.out.println("Original: " + arg);
            String quoted = HtmlQuoting.quoteHtmlChars(arg);
            System.out.println("Quoted: " + quoted);
            String unquoted = HtmlQuoting.unquoteHtmlChars(quoted);
            System.out.println("Unquoted: " + unquoted);
            System.out.println();
        }
    }
}

