/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.solvers;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverImpl;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverUtils;

public class BisectionSolver
extends UnivariateRealSolverImpl {
    @Deprecated
    public BisectionSolver(UnivariateRealFunction f) {
        super(f, 100, 1.0E-6);
    }

    public BisectionSolver() {
        super(100, 1.0E-6);
    }

    @Deprecated
    public double solve(double min2, double max2, double initial) throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.solve(this.f, min2, max2);
    }

    @Deprecated
    public double solve(double min2, double max2) throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.solve(this.f, min2, max2);
    }

    public double solve(UnivariateRealFunction f, double min2, double max2, double initial) throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.solve(min2, max2);
    }

    public double solve(UnivariateRealFunction f, double min2, double max2) throws MaxIterationsExceededException, FunctionEvaluationException {
        this.clearResult();
        this.verifyInterval(min2, max2);
        for (int i = 0; i < this.maximalIterationCount; ++i) {
            double m = UnivariateRealSolverUtils.midpoint(min2, max2);
            double fmin = f.value(min2);
            double fm = f.value(m);
            if (fm * fmin > 0.0) {
                min2 = m;
            } else {
                max2 = m;
            }
            if (!(Math.abs(max2 - min2) <= this.absoluteAccuracy)) continue;
            m = UnivariateRealSolverUtils.midpoint(min2, max2);
            this.setResult(m, i);
            return m;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }
}

