/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.commons.configuration.event.ConfigurationErrorEvent;
import org.apache.commons.configuration.event.ConfigurationErrorListener;
import org.apache.commons.configuration.event.EventSource;
import org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.NoOpLog;

public abstract class AbstractConfiguration
extends EventSource
implements Configuration {
    public static final int EVENT_ADD_PROPERTY = 1;
    public static final int EVENT_CLEAR_PROPERTY = 2;
    public static final int EVENT_SET_PROPERTY = 3;
    public static final int EVENT_CLEAR = 4;
    public static final int EVENT_READ_PROPERTY = 5;
    protected static final String START_TOKEN = "${";
    protected static final String END_TOKEN = "}";
    private static final char DISABLED_DELIMITER = '\u0000';
    private static char defaultListDelimiter = (char)44;
    private char listDelimiter = defaultListDelimiter;
    private boolean delimiterParsingDisabled;
    private boolean throwExceptionOnMissing;
    private StrSubstitutor substitutor;
    private Log log;

    public AbstractConfiguration() {
        this.setLogger(null);
    }

    public static void setDefaultListDelimiter(char delimiter) {
        defaultListDelimiter = delimiter;
    }

    public static void setDelimiter(char delimiter) {
        AbstractConfiguration.setDefaultListDelimiter(delimiter);
    }

    public static char getDefaultListDelimiter() {
        return defaultListDelimiter;
    }

    public static char getDelimiter() {
        return AbstractConfiguration.getDefaultListDelimiter();
    }

    public void setListDelimiter(char listDelimiter) {
        this.listDelimiter = listDelimiter;
    }

    public char getListDelimiter() {
        return this.listDelimiter;
    }

    public boolean isDelimiterParsingDisabled() {
        return this.delimiterParsingDisabled;
    }

    public void setDelimiterParsingDisabled(boolean delimiterParsingDisabled) {
        this.delimiterParsingDisabled = delimiterParsingDisabled;
    }

    public void setThrowExceptionOnMissing(boolean throwExceptionOnMissing) {
        this.throwExceptionOnMissing = throwExceptionOnMissing;
    }

    public boolean isThrowExceptionOnMissing() {
        return this.throwExceptionOnMissing;
    }

    public synchronized StrSubstitutor getSubstitutor() {
        if (this.substitutor == null) {
            this.substitutor = new StrSubstitutor(this.createInterpolator());
        }
        return this.substitutor;
    }

    public ConfigurationInterpolator getInterpolator() {
        return (ConfigurationInterpolator)this.getSubstitutor().getVariableResolver();
    }

    protected ConfigurationInterpolator createInterpolator() {
        ConfigurationInterpolator interpol = new ConfigurationInterpolator();
        interpol.setDefaultLookup(new StrLookup(){

            public String lookup(String var) {
                Object prop = AbstractConfiguration.this.resolveContainerStore(var);
                return prop != null ? prop.toString() : null;
            }
        });
        return interpol;
    }

    public Log getLogger() {
        return this.log;
    }

    public void setLogger(Log log2) {
        this.log = log2 != null ? log2 : new NoOpLog();
    }

    public void addErrorLogListener() {
        this.addErrorListener(new ConfigurationErrorListener(){

            public void configurationError(ConfigurationErrorEvent event) {
                AbstractConfiguration.this.getLogger().warn((Object)"Internal error", event.getCause());
            }
        });
    }

    public void addProperty(String key, Object value2) {
        this.fireEvent(1, key, value2, true);
        this.addPropertyValues(key, value2, this.isDelimiterParsingDisabled() ? (char)'\u0000' : this.getListDelimiter());
        this.fireEvent(1, key, value2, false);
    }

    protected abstract void addPropertyDirect(String var1, Object var2);

    private void addPropertyValues(String key, Object value2, char delimiter) {
        Iterator it = PropertyConverter.toIterator(value2, delimiter);
        while (it.hasNext()) {
            this.addPropertyDirect(key, it.next());
        }
    }

    protected String interpolate(String base) {
        Object result2 = this.interpolate((Object)base);
        return result2 == null ? null : result2.toString();
    }

    protected Object interpolate(Object value2) {
        return PropertyConverter.interpolate(value2, this);
    }

    protected String interpolateHelper(String base, List priorVariables) {
        return base;
    }

    public Configuration subset(String prefix) {
        return new SubsetConfiguration(this, prefix, ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String key, Object value2) {
        this.fireEvent(3, key, value2, true);
        this.setDetailEvents(false);
        try {
            this.clearProperty(key);
            this.addProperty(key, value2);
        }
        finally {
            this.setDetailEvents(true);
        }
        this.fireEvent(3, key, value2, false);
    }

    public void clearProperty(String key) {
        this.fireEvent(2, key, null, true);
        this.clearPropertyDirect(key);
        this.fireEvent(2, key, null, false);
    }

    protected void clearPropertyDirect(String key) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.fireEvent(4, null, null, true);
        this.setDetailEvents(false);
        boolean useIterator = true;
        try {
            Iterator it = this.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (useIterator) {
                    try {
                        it.remove();
                    }
                    catch (UnsupportedOperationException usoex) {
                        useIterator = false;
                    }
                }
                if (useIterator && this.containsKey(key)) {
                    useIterator = false;
                }
                if (useIterator) continue;
                this.clearProperty(key);
            }
        }
        finally {
            this.setDetailEvents(true);
        }
        this.fireEvent(4, null, null, false);
    }

    public Iterator getKeys(final String prefix) {
        return new FilterIterator(this.getKeys(), new Predicate(){

            public boolean evaluate(Object obj) {
                String key = (String)obj;
                return key.startsWith(prefix + ".") || key.equals(prefix);
            }
        });
    }

    public Properties getProperties(String key) {
        return this.getProperties(key, null);
    }

    public Properties getProperties(String key, Properties defaults) {
        String[] tokens = this.getStringArray(key);
        Properties props = defaults == null ? new Properties() : new Properties(defaults);
        for (int i = 0; i < tokens.length; ++i) {
            String token2 = tokens[i];
            int equalSign = token2.indexOf(61);
            if (equalSign <= 0) {
                if (tokens.length == 1 && "".equals(token2)) break;
                throw new IllegalArgumentException('\'' + token2 + "' does not contain an equals sign");
            }
            String pkey = token2.substring(0, equalSign).trim();
            String pvalue = token2.substring(equalSign + 1).trim();
            props.put(pkey, pvalue);
        }
        return props;
    }

    public boolean getBoolean(String key) {
        Boolean b = this.getBoolean(key, null);
        if (b != null) {
            return b;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(key, BooleanUtils.toBooleanObject(defaultValue));
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Object value2 = this.resolveContainerStore(key);
        if (value2 == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toBoolean(this.interpolate(value2));
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a Boolean object", e);
        }
    }

    public byte getByte(String key) {
        Byte b = this.getByte(key, null);
        if (b != null) {
            return b;
        }
        throw new NoSuchElementException('\'' + key + " doesn't map to an existing object");
    }

    public byte getByte(String key, byte defaultValue) {
        return this.getByte(key, new Byte(defaultValue));
    }

    public Byte getByte(String key, Byte defaultValue) {
        Object value2 = this.resolveContainerStore(key);
        if (value2 == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toByte(this.interpolate(value2));
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a Byte object", e);
        }
    }

    public double getDouble(String key) {
        Double d = this.getDouble(key, null);
        if (d != null) {
            return d;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public double getDouble(String key, double defaultValue) {
        return this.getDouble(key, new Double(defaultValue));
    }

    public Double getDouble(String key, Double defaultValue) {
        Object value2 = this.resolveContainerStore(key);
        if (value2 == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toDouble(this.interpolate(value2));
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a Double object", e);
        }
    }

    public float getFloat(String key) {
        Float f = this.getFloat(key, null);
        if (f != null) {
            return f.floatValue();
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public float getFloat(String key, float defaultValue) {
        return this.getFloat(key, new Float(defaultValue)).floatValue();
    }

    public Float getFloat(String key, Float defaultValue) {
        Object value2 = this.resolveContainerStore(key);
        if (value2 == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toFloat(this.interpolate(value2));
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a Float object", e);
        }
    }

    public int getInt(String key) {
        Integer i = this.getInteger(key, null);
        if (i != null) {
            return i;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public int getInt(String key, int defaultValue) {
        Integer i = this.getInteger(key, null);
        if (i == null) {
            return defaultValue;
        }
        return i;
    }

    public Integer getInteger(String key, Integer defaultValue) {
        Object value2 = this.resolveContainerStore(key);
        if (value2 == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toInteger(this.interpolate(value2));
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to an Integer object", e);
        }
    }

    public long getLong(String key) {
        Long l = this.getLong(key, null);
        if (l != null) {
            return l;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public long getLong(String key, long defaultValue) {
        return this.getLong(key, new Long(defaultValue));
    }

    public Long getLong(String key, Long defaultValue) {
        Object value2 = this.resolveContainerStore(key);
        if (value2 == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toLong(this.interpolate(value2));
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a Long object", e);
        }
    }

    public short getShort(String key) {
        Short s2 = this.getShort(key, null);
        if (s2 != null) {
            return s2;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public short getShort(String key, short defaultValue) {
        return this.getShort(key, new Short(defaultValue));
    }

    public Short getShort(String key, Short defaultValue) {
        Object value2 = this.resolveContainerStore(key);
        if (value2 == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toShort(this.interpolate(value2));
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a Short object", e);
        }
    }

    public BigDecimal getBigDecimal(String key) {
        BigDecimal number2 = this.getBigDecimal(key, null);
        if (number2 != null) {
            return number2;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
        }
        return null;
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        Object value2 = this.resolveContainerStore(key);
        if (value2 == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toBigDecimal(this.interpolate(value2));
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a BigDecimal object", e);
        }
    }

    public BigInteger getBigInteger(String key) {
        BigInteger number2 = this.getBigInteger(key, null);
        if (number2 != null) {
            return number2;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
        }
        return null;
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        Object value2 = this.resolveContainerStore(key);
        if (value2 == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toBigInteger(this.interpolate(value2));
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a BigDecimal object", e);
        }
    }

    public String getString(String key) {
        String s2 = this.getString(key, null);
        if (s2 != null) {
            return s2;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
        }
        return null;
    }

    public String getString(String key, String defaultValue) {
        Object value2 = this.resolveContainerStore(key);
        if (value2 instanceof String) {
            return this.interpolate((String)value2);
        }
        if (value2 == null) {
            return this.interpolate(defaultValue);
        }
        throw new ConversionException('\'' + key + "' doesn't map to a String object");
    }

    /*
     * WARNING - void declaration
     */
    public String[] getStringArray(String key) {
        void var3_3;
        String[] array;
        Object value2 = this.getProperty(key);
        if (value2 instanceof String) {
            array = new String[]{this.interpolate((String)value2)};
        } else if (value2 instanceof List) {
            List list2 = (List)value2;
            array = new String[list2.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = this.interpolate((String)list2.get(i));
            }
        } else if (value2 == null) {
            array = new String[]{};
        } else {
            throw new ConversionException('\'' + key + "' doesn't map to a String/List object");
        }
        return var3_3;
    }

    public List getList(String key) {
        return this.getList(key, new ArrayList());
    }

    /*
     * WARNING - void declaration
     */
    public List getList(String key, List defaultValue) {
        void var4_4;
        List<Object> list2;
        Object value2 = this.getProperty(key);
        if (value2 instanceof String) {
            list2 = new ArrayList<String>(1);
            list2.add(this.interpolate((String)value2));
        } else if (value2 instanceof List) {
            list2 = new ArrayList();
            List l = (List)value2;
            Iterator it = l.iterator();
            while (it.hasNext()) {
                list2.add(this.interpolate(it.next()));
            }
        } else if (value2 == null) {
            list2 = defaultValue;
        } else {
            if (value2.getClass().isArray()) {
                return Arrays.asList((Object[])value2);
            }
            throw new ConversionException('\'' + key + "' doesn't map to a List object: " + value2 + ", a " + value2.getClass().getName());
        }
        return var4_4;
    }

    protected Object resolveContainerStore(String key) {
        Object value2 = this.getProperty(key);
        if (value2 != null) {
            if (value2 instanceof Collection) {
                Collection collection = (Collection)value2;
                value2 = collection.isEmpty() ? null : collection.iterator().next();
            } else if (value2.getClass().isArray() && Array.getLength(value2) > 0) {
                value2 = Array.get(value2, 0);
            }
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(Configuration c) {
        if (c != null) {
            Iterator it = c.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object value2 = c.getProperty(key);
                this.fireEvent(3, key, value2, true);
                this.setDetailEvents(false);
                try {
                    this.clearProperty(key);
                    this.addPropertyValues(key, value2, '\u0000');
                }
                finally {
                    this.setDetailEvents(true);
                }
                this.fireEvent(3, key, value2, false);
            }
        }
    }

    public void append(Configuration c) {
        if (c != null) {
            Iterator it = c.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object value2 = c.getProperty(key);
                this.fireEvent(1, key, value2, true);
                this.addPropertyValues(key, value2, '\u0000');
                this.fireEvent(1, key, value2, false);
            }
        }
    }

    public Configuration interpolatedConfiguration() {
        AbstractConfiguration c = (AbstractConfiguration)ConfigurationUtils.cloneConfiguration(this);
        c.setDelimiterParsingDisabled(true);
        Iterator it = this.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            c.setProperty(key, this.getList(key));
        }
        c.setDelimiterParsingDisabled(this.isDelimiterParsingDisabled());
        return c;
    }
}

