/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import org.apache.avro.file.Codec;
import org.apache.avro.file.CodecFactory;
import org.xerial.snappy.Snappy;

class SnappyCodec
extends Codec {
    private CRC32 crc32 = new CRC32();

    private SnappyCodec() {
    }

    @Override
    public String getName() {
        return "snappy";
    }

    @Override
    public ByteBuffer compress(ByteBuffer in) throws IOException {
        ByteBuffer out = ByteBuffer.allocate(Snappy.maxCompressedLength(in.remaining()) + 4);
        int size2 = Snappy.compress(in.array(), in.position(), in.remaining(), out.array(), 0);
        this.crc32.reset();
        this.crc32.update(in.array(), in.position(), in.remaining());
        out.putInt(size2, (int)this.crc32.getValue());
        out.limit(size2 + 4);
        return out;
    }

    @Override
    public ByteBuffer decompress(ByteBuffer in) throws IOException {
        ByteBuffer out = ByteBuffer.allocate(Snappy.uncompressedLength(in.array(), in.position(), in.remaining() - 4));
        int size2 = Snappy.uncompress(in.array(), in.position(), in.remaining() - 4, out.array(), 0);
        out.limit(size2);
        this.crc32.reset();
        this.crc32.update(out.array(), 0, size2);
        if (in.getInt(in.limit() - 4) != (int)this.crc32.getValue()) {
            throw new IOException("Checksum failure");
        }
        return out;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return this.getClass() == obj.getClass();
    }

    static class Option
    extends CodecFactory {
        Option() {
        }

        @Override
        protected Codec createInstance() {
            return new SnappyCodec();
        }
    }
}

