/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.file;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import org.apache.avro.file.Codec;
import org.apache.avro.file.CodecFactory;

class DeflateCodec
extends Codec {
    private ByteArrayOutputStream outputBuffer;
    private Deflater deflater;
    private Inflater inflater;
    private boolean nowrap = true;
    private int compressionLevel;

    public DeflateCodec(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    @Override
    public String getName() {
        return "deflate";
    }

    @Override
    public ByteBuffer compress(ByteBuffer data2) throws IOException {
        ByteArrayOutputStream baos = this.getOutputBuffer(data2.remaining());
        DeflaterOutputStream ios = new DeflaterOutputStream((OutputStream)baos, this.getDeflater());
        this.writeAndClose(data2, ios);
        ByteBuffer result2 = ByteBuffer.wrap(baos.toByteArray());
        return result2;
    }

    @Override
    public ByteBuffer decompress(ByteBuffer data2) throws IOException {
        ByteArrayOutputStream baos = this.getOutputBuffer(data2.remaining());
        InflaterOutputStream ios = new InflaterOutputStream(baos, this.getInflater());
        this.writeAndClose(data2, ios);
        ByteBuffer result2 = ByteBuffer.wrap(baos.toByteArray());
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAndClose(ByteBuffer data2, OutputStream to2) throws IOException {
        byte[] input2 = data2.array();
        int offset = data2.arrayOffset() + data2.position();
        int length = data2.remaining();
        try {
            to2.write(input2, offset, length);
        }
        finally {
            to2.close();
        }
    }

    private Inflater getInflater() {
        if (null == this.inflater) {
            this.inflater = new Inflater(this.nowrap);
        }
        this.inflater.reset();
        return this.inflater;
    }

    private Deflater getDeflater() {
        if (null == this.deflater) {
            this.deflater = new Deflater(this.compressionLevel, this.nowrap);
        }
        this.deflater.reset();
        return this.deflater;
    }

    private ByteArrayOutputStream getOutputBuffer(int suggestedLength) {
        if (null == this.outputBuffer) {
            this.outputBuffer = new ByteArrayOutputStream(suggestedLength);
        }
        this.outputBuffer.reset();
        return this.outputBuffer;
    }

    @Override
    public int hashCode() {
        return this.nowrap ? 0 : 1;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeflateCodec other = (DeflateCodec)obj;
        return this.nowrap == other.nowrap;
    }

    @Override
    public String toString() {
        return this.getName() + "-" + this.compressionLevel;
    }

    static class Option
    extends CodecFactory {
        private int compressionLevel;

        Option(int compressionLevel) {
            this.compressionLevel = compressionLevel;
        }

        @Override
        protected Codec createInstance() {
            return new DeflateCodec(this.compressionLevel);
        }
    }
}

