/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.common.KafkaException;
import kafka.common.KafkaStorageException;
import kafka.utils.Crc32;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcZ$sp;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.TraitSetter;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class Utils$
implements Logging {
    public static final Utils$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new Utils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    @TraitSetter
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Runnable runnable(Function0<BoxedUnit> fun) {
        return new Runnable(fun){
            private final Function0 fun$1;

            public void run() {
                this.fun$1.apply$mcV$sp();
            }
            {
                this.fun$1 = fun$1;
            }
        };
    }

    public Thread daemonThread(Runnable runnable) {
        return this.newThread(runnable, true);
    }

    public Thread daemonThread(String name, Runnable runnable) {
        return this.newThread(name, runnable, true);
    }

    public Thread daemonThread(String name, Function0<BoxedUnit> fun) {
        return this.daemonThread(name, this.runnable((Function0<BoxedUnit>)((Object)new Serializable(fun){
            public static final long serialVersionUID = 0L;
            private final Function0 fun$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
            }
            {
                this.fun$2 = fun$2;
            }
        })));
    }

    public Thread newThread(String name, Runnable runnable, boolean daemon) {
        Thread thread = new Thread(runnable, name);
        thread.setDaemon(daemon);
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                Utils$.MODULE$.error((Function0<String>)((Object)new Serializable(this, t){
                    public static final long serialVersionUID = 0L;
                    private final Thread t$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Uncaught exception in thread '").append((Object)this.t$1.getName()).append((Object)"':").toString();
                    }
                    {
                        this.t$1 = t$1;
                    }
                }), (Function0<Throwable>)((Object)new Serializable(this, e){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$1;

                    public final Throwable apply() {
                        return this.e$1;
                    }
                    {
                        this.e$1 = e$1;
                    }
                }));
            }
        });
        return thread;
    }

    /*
     * WARNING - void declaration
     */
    public Thread newThread(Runnable runnable, boolean daemon) {
        void var3_3;
        Thread thread = new Thread(runnable);
        thread.setDaemon(daemon);
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                Utils$.MODULE$.error((Function0<String>)((Object)new Serializable(this, t){
                    public static final long serialVersionUID = 0L;
                    private final Thread t$2;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Uncaught exception in thread '").append((Object)this.t$2.getName()).append((Object)"':").toString();
                    }
                    {
                        this.t$2 = t$2;
                    }
                }), (Function0<Throwable>)((Object)new Serializable(this, e){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$2;

                    public final Throwable apply() {
                        return this.e$2;
                    }
                    {
                        this.e$2 = e$2;
                    }
                }));
            }
        });
        return var3_3;
    }

    public byte[] readBytes(ByteBuffer buffer) {
        return this.readBytes(buffer, 0, buffer.limit());
    }

    public byte[] readBytes(ByteBuffer buffer, int offset, int size2) {
        Object object;
        byte[] dest = new byte[size2];
        if (buffer.hasArray()) {
            System.arraycopy(buffer.array(), buffer.arrayOffset() + offset, dest, 0, size2);
            object = BoxedUnit.UNIT;
        } else {
            buffer.mark();
            buffer.get(dest);
            object = buffer.reset();
        }
        return dest;
    }

    /*
     * WARNING - void declaration
     */
    public Properties loadProps(String filename) {
        void var2_2;
        block3: {
            Properties props = new Properties();
            FileInputStream propStream = null;
            try {
                propStream = new FileInputStream(filename);
                props.load(propStream);
                if (propStream == null) break block3;
            }
            catch (Throwable throwable) {
                void var3_3;
                if (var3_3 != null) {
                    var3_3.close();
                }
                throw throwable;
            }
            ((InputStream)propStream).close();
        }
        return var2_2;
    }

    public FileChannel openChannel(File file, boolean mutable) {
        return mutable ? new RandomAccessFile(file, "rw").getChannel() : new FileInputStream(file).getChannel();
    }

    public void swallow(Function2<Object, Throwable, BoxedUnit> log2, Function0<BoxedUnit> action) {
        try {
            action.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            log2.apply(throwable.getMessage(), throwable);
        }
    }

    public boolean equal(ByteBuffer b1, ByteBuffer b2) {
        Object object = new Object();
        try {
            if (b1.position() != b2.position()) {
                return false;
            }
            if (b1.remaining() != b2.remaining()) {
                return false;
            }
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), b1.remaining()).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(b1, b2, object){
                public static final long serialVersionUID = 0L;
                private final ByteBuffer b1$1;
                private final ByteBuffer b2$1;
                private final Object nonLocalReturnKey1$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    if (this.b1$1.get(i) != this.b2$1.get(i)) {
                        throw new NonLocalReturnControl$mcZ$sp(this.nonLocalReturnKey1$1, false);
                    }
                }
                {
                    this.b1$1 = b1$1;
                    this.b2$1 = b2$1;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            }));
            return true;
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return nonLocalReturnControl.value$mcZ$sp();
            }
            throw nonLocalReturnControl;
        }
    }

    public String readString(ByteBuffer buffer, String encoding) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new String(bytes, encoding);
    }

    public void croak(String message) {
        System.err.println(message);
        System.exit(1);
    }

    public void rm(String file) {
        this.rm(new File(file));
    }

    public void rm(Seq<String> files) {
        files.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String f) {
                Utils$.MODULE$.rm(new File(f));
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void rm(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                Predef$.MODULE$.refArrayOps((Object[])files).foreach(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(File f) {
                        Utils$.MODULE$.rm(f);
                    }
                });
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean registerMBean(Object mbean, String name) {
        try {
            Boolean bl2;
            MBeanServer mbs;
            MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
            synchronized (mBeanServer) {
                ObjectName objName = new ObjectName(name);
                if (mbs.isRegistered(objName)) {
                    mbs.unregisterMBean(objName);
                }
                mbs.registerMBean(mbean, objName);
                bl2 = BoxesRunTime.boxToBoolean(true);
            }
            boolean bl = BoxesRunTime.unboxToBoolean(bl2);
            return bl;
        }
        catch (Exception exception) {
            this.error((Function0<String>)((Object)new Serializable(name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to register Mbean ").append((Object)this.name$1).toString();
                }
                {
                    this.name$1 = name$1;
                }
            }), (Function0<Throwable>)((Object)new Serializable(exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$3;

                public final Exception apply() {
                    return this.e$3;
                }
                {
                    this.e$3 = e$3;
                }
            }));
            return false;
        }
    }

    public void unregisterMBean(String name) {
        MBeanServer mbs;
        MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
        synchronized (mBeanServer) {
            BoxedUnit boxedUnit;
            ObjectName objName = new ObjectName(name);
            if (mbs.isRegistered(objName)) {
                mbs.unregisterMBean(objName);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public long readUnsignedInt(ByteBuffer buffer) {
        return (long)buffer.getInt() & 0xFFFFFFFFL;
    }

    public long readUnsignedInt(ByteBuffer buffer, int index2) {
        return (long)buffer.getInt(index2) & 0xFFFFFFFFL;
    }

    public void writetUnsignedInt(ByteBuffer buffer, long value2) {
        buffer.putInt((int)(value2 & 0xFFFFFFFFL));
    }

    public void writeUnsignedInt(ByteBuffer buffer, int index2, long value2) {
        buffer.putInt(index2, (int)(value2 & 0xFFFFFFFFL));
    }

    public long crc32(byte[] bytes) {
        return this.crc32(bytes, 0, bytes.length);
    }

    public long crc32(byte[] bytes, int offset, int size2) {
        Crc32 crc = new Crc32();
        crc.update(bytes, offset, size2);
        return crc.getValue();
    }

    public int hashcode(Seq<Object> as) {
        if (as == null) {
            return 0;
        }
        int h = 1;
        int i = 0;
        while (i < as.length()) {
            if (as.apply(i) == null) continue;
            h = 31 * h + as.apply(i).hashCode();
            ++i;
        }
        return h;
    }

    /*
     * WARNING - void declaration
     */
    public <K, V> Map<K, List<V>> groupby(Iterable<V> vals, Function1<V, K> f) {
        void var3_3;
        HashMap m = new HashMap();
        vals.foreach(new Serializable(f, m){
            public static final long serialVersionUID = 0L;
            private final Function1 f$1;
            private final HashMap m$1;

            public final Option<List<V>> apply(V v) {
                Option<B> option;
                block4: {
                    Option<GenTraversable<Object>> option2;
                    block3: {
                        R k;
                        block2: {
                            Some some;
                            List l;
                            k = this.f$1.apply(v);
                            option = this.m$1.get(k);
                            if (!(option instanceof Some) || (l = (List)(some = (Some)option).x()) == null) break block2;
                            List list2 = l;
                            V v2 = v;
                            option2 = this.m$1.put(k, list2.$colon$colon(v2));
                            break block3;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<B> option3 = option;
                        if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                        option2 = this.m$1.put(k, List$.MODULE$.apply(Predef$.MODULE$.genericWrapArray(new Object[]{v})));
                    }
                    return option2;
                }
                throw new MatchError(option);
            }
            {
                this.f$1 = f$1;
                this.m$1 = m$1;
            }
        });
        return var3_3;
    }

    public int read(ReadableByteChannel channel, ByteBuffer buffer) {
        int n;
        int n2 = channel.read(buffer);
        if (-1 == n2) {
            throw new EOFException("Received -1 when reading from channel, socket has likely been closed.");
        }
        int n3 = n = n2;
        return n3;
    }

    public String readString$default$2() {
        return Charset.defaultCharset().toString();
    }

    public <V> V notNull(V v) {
        if (v == null) {
            throw new KafkaException("Value cannot be null.");
        }
        return v;
    }

    public String stackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public Map<String, String> parseCsvMap(String str) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        if ("".equals(str)) {
            return map2;
        }
        String[][] keyVals = (String[][])Predef$.MODULE$.refArrayOps((Object[])str.split("\\s*,\\s*")).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String s2) {
                return s2.split("\\s*:\\s*");
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])keyVals).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String[] pair2) {
                return new Tuple2<String, String>(pair2[0], pair2[1]);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms());
    }

    public Seq<String> parseCsvList(String csvList) {
        return csvList == null || csvList.isEmpty() ? (WrappedArray<Object>)Seq$.MODULE$.empty() : Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])csvList.split("\\s*,\\s*")).filter(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String v) {
                return !v.equals("");
            }
        }));
    }

    public <T> T createObject(String className, Seq<Object> args) {
        Class<?> klass = Class.forName(className);
        Constructor<?> constructor = klass.getConstructor((Class[])((TraversableOnce)args.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<?> apply(Object x$2) {
                return x$2.getClass();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Class.class)));
        return (T)constructor.newInstance((Object[])args.toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public boolean nullOrEmpty(String s2) {
        return s2 == null || s2.equals("");
    }

    public <T> Iterator<T> circularIterator(Iterable<T> coll) {
        Stream stream = package$.MODULE$.Stream().continually(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 1;
            }
        }).flatMap(new Serializable(coll){
            public static final long serialVersionUID = 0L;
            private final Iterable coll$1;

            public final Iterable<T> apply(int forever) {
                return this.coll$1.map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final T apply(T t) {
                        return t;
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
            {
                this.coll$1 = coll$1;
            }
        }, Stream$.MODULE$.canBuildFrom());
        return stream.iterator();
    }

    public String readFileAsString(String path, Charset charset) {
        FileInputStream stream = new FileInputStream(new File(path));
        try {
            FileChannel fc = stream.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            return charset.decode(bb).toString();
        }
        finally {
            stream.close();
        }
    }

    public Charset readFileAsString$default$2() {
        return Charset.defaultCharset();
    }

    public int abs(int n) {
        return n == Integer.MIN_VALUE ? 0 : scala.math.package$.MODULE$.abs(n);
    }

    public String replaceSuffix(String s2, String oldSuffix, String newSuffix) {
        if (s2.endsWith(oldSuffix)) {
            return new StringBuilder().append((Object)s2.substring(0, s2.length() - oldSuffix.length())).append((Object)newSuffix).toString();
        }
        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Expected string to end with '%s' but string is '%s'")).format(Predef$.MODULE$.genericWrapArray(new Object[]{oldSuffix, s2})));
    }

    /*
     * WARNING - void declaration
     */
    public File createFile(String path) {
        File f = new File(path);
        boolean created = f.createNewFile();
        if (created) {
            void var2_2;
            return var2_2;
        }
        throw new KafkaStorageException(new StringOps(Predef$.MODULE$.augmentString("Failed to create file %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{path})));
    }

    public String asString(Properties props) {
        StringWriter writer = new StringWriter();
        props.store(writer, "");
        return writer.toString();
    }

    public Properties readProps(String s2, Properties defaults) {
        StringReader reader = new StringReader(s2);
        Properties props = new Properties(defaults);
        props.load(reader);
        return props;
    }

    public int readInt(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public <T> T inLock(Lock lock2, Function0<T> fun) {
        lock2.lock();
        try {
            return fun.apply();
        }
        finally {
            lock2.unlock();
        }
    }

    public <T> T inReadLock(ReadWriteLock lock2, Function0<T> fun) {
        return this.inLock(lock2.readLock(), fun);
    }

    public <T> T inWriteLock(ReadWriteLock lock2, Function0<T> fun) {
        return this.inLock(lock2.writeLock(), fun);
    }

    public String JSONEscapeString(String s2) {
        return ((TraversableOnce)new StringOps(Predef$.MODULE$.augmentString(s2)).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(char x0$1) {
                Object object;
                char c = x0$1;
                switch (c) {
                    default: {
                        if (c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f') {
                            object = new StringOps(Predef$.MODULE$.augmentString("\\u%04x")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(c)}));
                            break;
                        }
                        object = BoxesRunTime.boxToCharacter(c);
                        break;
                    }
                    case '\t': {
                        object = "\\t";
                        break;
                    }
                    case '\r': {
                        object = "\\r";
                        break;
                    }
                    case '\n': {
                        object = "\\n";
                        break;
                    }
                    case '\f': {
                        object = "\\f";
                        break;
                    }
                    case '\b': {
                        object = "\\b";
                        break;
                    }
                    case '/': {
                        object = "\\/";
                        break;
                    }
                    case '\\': {
                        object = "\\\\";
                        break;
                    }
                    case '\"': {
                        object = "\\\"";
                    }
                }
                return object;
            }
        }, Predef$.MODULE$.fallbackStringCanBuildFrom())).mkString();
    }

    public <T> Iterable<T> duplicates(Traversable<T> s2) {
        return ((MapLike)((TraversableLike)s2.groupBy(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final T apply(T x) {
                return Predef$.MODULE$.identity(x);
            }
        }).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<T, Object> apply(Tuple2<T, Traversable<T>> x0$2) {
                Tuple2<T, Traversable<T>> tuple2 = x0$2;
                if (tuple2 != null) {
                    T k = tuple2._1();
                    Traversable<T> l = tuple2._2();
                    Tuple2<T, Integer> tuple22 = new Tuple2<T, Integer>(k, BoxesRunTime.boxToInteger(l.size()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom())).filter(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<T, Object> x0$3) {
                Tuple2<T, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    int l = tuple2._2$mcI$sp();
                    boolean bl = l > 1;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).keys();
    }

    private Utils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

