/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.FileWriter;
import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.tools.ExportZkOffsets$;
import kafka.tools.ExportZkOffsets$$anonfun$main$1$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ExportZkOffsets$
implements Logging {
    public static final ExportZkOffsets$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ExportZkOffsets$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ExportZkOffsets$ exportZkOffsets$ = this;
        synchronized (exportZkOffsets$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        OptionSet options;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec zkConnectOpt = parser.accepts("zkconnect", "ZooKeeper connect string.").withRequiredArg().defaultsTo((Object)"localhost:2181", (Object[])new String[0]).ofType(String.class);
        ArgumentAcceptingOptionSpec groupOpt = parser.accepts("group", "Consumer group.").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec outFileOpt = parser.accepts("output-file", "Output file").withRequiredArg().ofType(String.class);
        parser.accepts("help", "Print this message.");
        if (args.length == 0) {
            CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Export consumer offsets to an output file.");
        }
        if ((options = parser.parse(args)).has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{zkConnectOpt, outFileOpt}));
        String zkConnect = (String)options.valueOf((OptionSpec)zkConnectOpt);
        java.util.List groups = options.valuesOf((OptionSpec)groupOpt);
        String outfile = (String)options.valueOf((OptionSpec)outFileOpt);
        ObjectRef<Object> zkClient = new ObjectRef<Object>(null);
        FileWriter fileWriter = new FileWriter(outfile);
        try {
            zkClient.elem = new ZkClient(zkConnect, 30000, 30000, ZKStringSerializer$.MODULE$);
            Seq<String> consumerGroups = null;
            consumerGroups = groups.size() == 0 ? ZkUtils$.MODULE$.getChildren((ZkClient)zkClient.elem, ZkUtils$.MODULE$.ConsumersPath()).toList() : JavaConversions$.MODULE$.asScalaBuffer(groups);
            consumerGroups.foreach(new Serializable(zkClient, fileWriter){
                public static final long serialVersionUID = 0L;
                public final ObjectRef zkClient$1;
                public final FileWriter fileWriter$1;

                public final void apply(String consumerGrp) {
                    List<String> topicsList = ExportZkOffsets$.MODULE$.kafka$tools$ExportZkOffsets$$getTopicsList((ZkClient)this.zkClient$1.elem, consumerGrp);
                    topicsList.foreach(new Serializable(this, consumerGrp){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.main.1 $outer;
                        public final String consumerGrp$1;

                        public final void apply(String topic) {
                            List<String> bidPidList = ExportZkOffsets$.MODULE$.kafka$tools$ExportZkOffsets$$getBrokeridPartition((ZkClient)this.$outer.zkClient$1.elem, this.consumerGrp$1, topic);
                            bidPidList.foreach(new Serializable(this, topic){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$main$1$$anonfun$apply$1 $outer;
                                private final String topic$1;

                                public final void apply(String bidPid) {
                                    Option<String> option;
                                    block4: {
                                        block3: {
                                            String offsetPath;
                                            block2: {
                                                ZKGroupTopicDirs zkGrpTpDir = new ZKGroupTopicDirs(this.$outer.consumerGrp$1, this.topic$1);
                                                offsetPath = new StringBuilder().append((Object)zkGrpTpDir.consumerOffsetDir()).append((Object)"/").append((Object)bidPid).toString();
                                                option = ZkUtils$.MODULE$.readDataMaybeNull((ZkClient)this.$outer.kafka$tools$ExportZkOffsets$$anonfun$$anonfun$$$outer().zkClient$1.elem, offsetPath)._1();
                                                if (!(option instanceof Some)) break block2;
                                                Some some = (Some)option;
                                                String offsetVal = (String)some.x();
                                                this.$outer.kafka$tools$ExportZkOffsets$$anonfun$$anonfun$$$outer().fileWriter$1.write(new StringBuilder().append((Object)offsetPath).append((Object)":").append((Object)offsetVal).append((Object)"\n").toString());
                                                ExportZkOffsets$.MODULE$.debug((Function0<String>)((Object)new Serializable(this, offsetPath, offsetVal){
                                                    public static final long serialVersionUID = 0L;
                                                    private final String offsetPath$1;
                                                    private final String offsetVal$1;

                                                    public final String apply() {
                                                        return new StringBuilder().append((Object)this.offsetPath$1).append((Object)" => ").append((Object)this.offsetVal$1).toString();
                                                    }
                                                    {
                                                        this.offsetPath$1 = offsetPath$1;
                                                        this.offsetVal$1 = offsetVal$1;
                                                    }
                                                }));
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block3;
                                            }
                                            None$ none$ = None$.MODULE$;
                                            Option<String> option2 = option;
                                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                                            ExportZkOffsets$.MODULE$.error((Function0<String>)((Object)new Serializable(this, offsetPath){
                                                public static final long serialVersionUID = 0L;
                                                private final String offsetPath$1;

                                                public final String apply() {
                                                    return new StringBuilder().append((Object)"Could not retrieve offset value from ").append((Object)this.offsetPath$1).toString();
                                                }
                                                {
                                                    this.offsetPath$1 = offsetPath$1;
                                                }
                                            }));
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        }
                                        return;
                                    }
                                    throw new MatchError(option);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.topic$1 = topic$1;
                                }
                            });
                        }

                        public /* synthetic */ anonfun.main.1 kafka$tools$ExportZkOffsets$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.consumerGrp$1 = consumerGrp$1;
                        }
                    });
                }
                {
                    this.zkClient$1 = zkClient$1;
                    this.fileWriter$1 = fileWriter$1;
                }
            });
            return;
        }
        finally {
            fileWriter.flush();
            fileWriter.close();
        }
    }

    public List<String> kafka$tools$ExportZkOffsets$$getBrokeridPartition(ZkClient zkClient, String consumerGroup, String topic) {
        return ZkUtils$.MODULE$.getChildrenParentMayNotExist(zkClient, new StringOps(Predef$.MODULE$.augmentString("/consumers/%s/offsets/%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{consumerGroup, topic}))).toList();
    }

    public List<String> kafka$tools$ExportZkOffsets$$getTopicsList(ZkClient zkClient, String consumerGroup) {
        return ZkUtils$.MODULE$.getChildren(zkClient, new StringOps(Predef$.MODULE$.augmentString("/consumers/%s/offsets")).format(Predef$.MODULE$.genericWrapArray(new Object[]{consumerGroup}))).toList();
    }

    private ExportZkOffsets$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

