/*

Easy way to control 7 segment displays by Arduino

Stefan Hermann
www.fritzing.org


         _________           _________           _________           _________
        /____a____\         /____a____\         /____a____\         /____a____\
       | |       | |       | |       | |       | |       | |       | |       | | 
       |f|       |b|       |f|       |b|       |f|       |b|       |f|       |b|
       | |       | |       | |       | |       | |       | |       | |       | |       
       \_/_______\_/       \_/_______\_/       \_/_______\_/       \_/_______\_/
        _|___g___|_         _|___g___|_         _|___g___|_         _|___g___|_ 
       / \       / \       / \       / \       / \       / \       / \       / \
       | |       | |       | |       | |       | |       | |       | |       | |
       |e|       |c|       |e|       |c|       |e|       |c|       |e|       |c|
       \_/_______\_/ __    \_/_______\_/ __    \_/_______\_/ __    \_/_______\_/ __
        \____d____/ |DP|    \____d____/ |DP|    \____d____/ |DP|    \____d____/ |DP|
  
         Digit 4             Digit 3             Digit 2             Digit 1            
*/

const int numberOfSegments = 8;                            // do not change
int segmentPins[numberOfSegments] = {2,3,4,5,6,7,8,9};     // change to your pins a,b,c,d,e,f,g,DP
  
const int numberOfDigits = 4;                              // change to the number of digits
int commonPins[numberOfDigits] = {13,12,11,10};            // change to the pins of digits starting with the left digit

int displayType=1;                                         // change to the type of your display: common anode = 1; common cathode = 2;

int myNumber=0;

int theFigures[11][7]={
{1,1,1,1,1,1,0},
{0,1,1,0,0,0,0},
{1,1,0,1,1,0,1},
{1,1,1,1,0,0,1},
{0,1,1,0,0,1,1},
{1,0,1,1,0,1,1},
{1,0,1,1,1,1,1},
{1,1,1,0,0,0,0},
{1,1,1,1,1,1,1},
{1,1,1,0,0,1,1},
{0,0,0,0,0,0,1}};

void setup(){  
  // config for the display
  for (int i=0; i<numberOfSegments;i++){
    pinMode(segmentPins[i],OUTPUT);
  }
  
  for (int i=0; i<numberOfDigits;i++){
    pinMode(commonPins[i],OUTPUT);
  }
  
  // type your setup code here
  
}

void loop(){
  // type in your loop code here
  
  // this is just for the example:
  showNumber(myNumber);        // display the number
  if (  myNumber++;
  delay(1);

}

// do not change the methods below

void showNumber(int theNumber){
  for (int stelle=numberOfDigits; stelle>=0; stelle--){
    char szZahl[numberOfDigits];
    sprintf(szZahl, "%d", theNumber);
    int stellen = strlen(szZahl);
    if (stelle > stellen) {
      
    } else {
      int ergebnis = szZahl[stelle] - '0';
      if (ergebnis>-1){
        digit(((numberOfDigits-1)-(stellen-(stelle+1))),ergebnis);
      } 
      else {
        digit(((numberOfDigits-1)-(stellen-(stelle+1))),0);
      }
    }
    delay(1);
    clearDisplay();
  }
}



void digit(int theDigit, int theNumber){
  if (displayType==1){
    digitalWrite(commonPins[theDigit], HIGH);
      for (int i=0; i<7; i++){
      if (theFigures[theNumber][i]==0){
        digitalWrite(segmentPins[i],HIGH);
      } else {
        digitalWrite(segmentPins[i],LOW);
      }
    }
  } else {
    digitalWrite(commonPins[theDigit], LOW);
    for (int i=0; i<7; i++){
      digitalWrite(segmentPins[i],theFigures[theNumber][i]);    
    }

  }  
}

void clearDisplay(){
  for (int theDigit=0; theDigit<numberOfDigits;theDigit++){
  if (displayType==1){
    digitalWrite(commonPins[theDigit], LOW);
      for (int i=0; i<7; i++){
        digitalWrite(segmentPins[i],HIGH);     
    }
  } else {
    digitalWrite(commonPins[theDigit], HIGH);
    for (int i=0; i<7; i++){
        digitalWrite(segmentPins[i],LOW);
    }
  }  
  }
}