/*
Code by Frerk Popovic

*/


// Using the Timer-Interrupt from: http://www.arduino.cc/playground/Main/MsTimer2
#include <MsTimer2.h>
// and the Bounce-Library to debounce http://www.arduino.cc/playground/Code/Bounce
#include <Bounce.h>

// for debugging set to 1 and use the serial monitor:
const int DEBUG = 1;

// shift register:
const int latchPin = 8; 
const int dataPin = 11; 
const int clockPin = 12; 

// Pushbuttons
const int leftButton = 6;
const int rightButton = 5; 

int leftButtonState = 0; // is the left button pushed?
int leftButtonLastState = 0; // what was it's last state?

int rightButtonState = 0; // is the right button pushed?

Bounce bouncerLeft = Bounce(leftButton,50); 
Bounce bouncerRight = Bounce(rightButton,50); 

int seconds = 0;

/*
7-Segment-Display:
 a-7  <-> Q0
 b-6  <-> Q1
 c-4  <-> Q2
 d-2  <-> Q3
 e-1  <-> Q4
 f-9  <-> Q5
 g-10 <-> Q6 
 dp-5 <-> Q7 not used
 
 display of one digit numbers:

 0:   f+e+d+c+b+a = 63
 1:         c+b   = 0*2^7 + 0*2^6 + 0*2^5 + 0*2^4 + 0*2^3 + 1^*2^2 + 1*2^1 +0*2^0 = 00000110b = 6
 2: g+  e+d+  b+a = 91
 3: g+    d+c+b+a = 79
 4: g+f+    c+b   = 102
 5: g+f+  d+c+  a = 109
 6: g+f+e+d+c+  a = 125
 7:         c+b+a = 7
 8: g+f+e+d+c+b+a = 127 
 9: g+f+  d+c+b+a = 111
 
 */
int numbers[10] = {
  63, 6, 91, 79, 102, 109, 125, 7, 127, 111};

// Relais for:
const int pump = 10;
const int solenoid = 13; 

void setup()
{
  if(DEBUG){
    Serial.begin(9600);
  }

  pinMode(latchPin, OUTPUT);
  pinMode(clockPin, OUTPUT);
  pinMode(dataPin, OUTPUT);

  pinMode(leftButton, INPUT);
  pinMode(rightButton, INPUT);

  clearDisplays(); 
  delay(100);
  alleAn(); // LED-Test
  delay(500);
  clearDisplays();
  sayHello();
  clearDisplays(); 
  alleAn(); // LED-Test
  delay(1000);

  MsTimer2::set(1000, zeitLaeuft);  

}

void loop()
{
  // 
  bouncerLeft.update();
  leftButtonState = bouncerLeft.read();
  //leftButtonState = digitalRead(leftButton);

  if(DEBUG && leftButtonState && bouncerLeft.duration() > 100 == 1){
    Serial.print("last and current state of buttons:  ");
    Serial.print(leftButtonLastState);
    Serial.print("   ");
    Serial.println(leftButtonState);
    Serial.println("------------------------------------------------");
  }

  if(leftButtonState == 1 && bouncerLeft.duration() > 100 && leftButtonLastState == 0){
    seconds = 0;
    startClock();
    leftButtonLastState++;
  } 
  else if (leftButtonState == 1 && bouncerLeft.duration() > 100 && leftButtonLastState == 1){
    stopClock();
    leftButtonLastState++;
    seconds = 0;
    startClock();    
  }

  bouncerRight.update();
  if(bouncerRight.read() && bouncerRight.duration() > 100){
    rightButtonState = 1;
  } 
  else {
    rightButtonState = 0;
  }

  if(rightButtonState){
    stopClock();
    leftButtonLastState = 0;
    if(DEBUG){
      Serial.println("Right");
      Serial.print("Last state of left button:  ");
      Serial.println(leftButtonLastState);
      Serial.println("|||||||||||||||||STOP||||||||||||||||||||||||||");
    }
  }
  showTime();

}

void showTime(){

  // if(DEBUG){
  //      Serial.print("Die Einerstelle ist: ");
  //      Serial.println(int(seconds%10), DEC);
  //      Serial.print("Die Zehnerstelle ist: ");
  //      Serial.println(int(seconds/10), DEC);
  //      Serial.println("-----------------------------------");
  //    }  
  zahlAusgeben(int(seconds/10),int(seconds%10));
}



void clearDisplays(){
  digitalWrite(latchPin, LOW);
  shiftOut(dataPin, clockPin, LSBFIRST, 0); 
  shiftOut(dataPin, clockPin, LSBFIRST, 0); 
  digitalWrite(latchPin, HIGH);
}

void alleAn(){
  zahlAusgeben(8,8);
}

void sayHello(){
  int pause = 100;
  for(int a = 0;a<3;a++){
    digitalWrite(latchPin, LOW);
    shiftOut(dataPin, clockPin, MSBFIRST,1);
    digitalWrite(latchPin, HIGH);
    delay(pause); 
    digitalWrite(latchPin, LOW);
    shiftOut(dataPin, clockPin, MSBFIRST,0);
    digitalWrite(latchPin, HIGH);
    delay(pause); 
    for(int i =1;i<4;i++){
      digitalWrite(latchPin, LOW);
      shiftOut(dataPin, clockPin, MSBFIRST,int(0.01+pow(2,i)));
      shiftOut(dataPin, clockPin, MSBFIRST,0);
      digitalWrite(latchPin, HIGH);
      delay(pause); 
    }
    for(int i =3;i<6;i++){
      digitalWrite(latchPin, LOW);
      shiftOut(dataPin, clockPin, MSBFIRST,0);
      shiftOut(dataPin, clockPin, MSBFIRST,int(0.1+pow(2,i)));
      digitalWrite(latchPin, HIGH);
      delay(pause); 
    }
    clearDisplays();  
    }
  }

  void zahlAusgeben(int zehner, int einer){
    digitalWrite(latchPin, LOW);
    shiftOut(dataPin, clockPin, MSBFIRST, numbers[einer]); 
    shiftOut(dataPin, clockPin, MSBFIRST, numbers[zehner]);
    digitalWrite(latchPin, HIGH);
  }

void startClock(){
  MsTimer2::start(); // enable Interrupt
  if(DEBUG) Serial.println("Timer started!");
}

void stopClock(){
  MsTimer2::stop(); // disable Interrupt
  if(DEBUG) Serial.println("Timer stopped!");
}


void zeitLaeuft(){
  seconds++;
  if(DEBUG){
    Serial.println("+++++++++++++++Time:+++++++++++++++++");
    Serial.println(seconds);
  }
}